/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.utils;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CalciteUtilsTest {
    RelDataTypeFactory dataTypeFactory;

    @Before
    public void setUp() {
        this.dataTypeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
    }

    Map<String, RelDataType> calciteRowTypeFields(Schema schema) {
        RelDataType dataType = CalciteUtils.toCalciteRowType((Schema)schema, (RelDataTypeFactory)this.dataTypeFactory);
        return dataType.getFieldNames().stream().collect(Collectors.toMap(x -> x, x -> dataType.getField((String)x, true, false).getType()));
    }

    @Test
    public void testToCalciteRowType() {
        Schema schema = Schema.builder().addField("f1", Schema.FieldType.BYTE).addField("f2", Schema.FieldType.INT16).addField("f3", Schema.FieldType.INT32).addField("f4", Schema.FieldType.INT64).addField("f5", Schema.FieldType.FLOAT).addField("f6", Schema.FieldType.DOUBLE).addField("f7", Schema.FieldType.DECIMAL).addField("f8", Schema.FieldType.BOOLEAN).addField("f9", Schema.FieldType.BYTES).addField("f10", Schema.FieldType.STRING).build();
        Map<String, RelDataType> fields = this.calciteRowTypeFields(schema);
        Assert.assertEquals((long)10L, (long)fields.size());
        fields.values().forEach(x -> Assert.assertFalse((boolean)x.isNullable()));
        Assert.assertEquals((Object)((Object)SqlTypeName.TINYINT), (Object)((Object)fields.get("f1").getSqlTypeName()));
        Assert.assertEquals((Object)((Object)SqlTypeName.SMALLINT), (Object)((Object)fields.get("f2").getSqlTypeName()));
        Assert.assertEquals((Object)((Object)SqlTypeName.INTEGER), (Object)((Object)fields.get("f3").getSqlTypeName()));
        Assert.assertEquals((Object)((Object)SqlTypeName.BIGINT), (Object)((Object)fields.get("f4").getSqlTypeName()));
        Assert.assertEquals((Object)((Object)SqlTypeName.FLOAT), (Object)((Object)fields.get("f5").getSqlTypeName()));
        Assert.assertEquals((Object)((Object)SqlTypeName.DOUBLE), (Object)((Object)fields.get("f6").getSqlTypeName()));
        Assert.assertEquals((Object)((Object)SqlTypeName.DECIMAL), (Object)((Object)fields.get("f7").getSqlTypeName()));
        Assert.assertEquals((Object)((Object)SqlTypeName.BOOLEAN), (Object)((Object)fields.get("f8").getSqlTypeName()));
        Assert.assertEquals((Object)((Object)SqlTypeName.VARBINARY), (Object)((Object)fields.get("f9").getSqlTypeName()));
        Assert.assertEquals((Object)((Object)SqlTypeName.VARCHAR), (Object)((Object)fields.get("f10").getSqlTypeName()));
    }

    @Test
    public void testToCalciteRowTypeNullable() {
        Schema schema = Schema.builder().addNullableField("f1", Schema.FieldType.BYTE).addNullableField("f2", Schema.FieldType.INT16).addNullableField("f3", Schema.FieldType.INT32).addNullableField("f4", Schema.FieldType.INT64).addNullableField("f5", Schema.FieldType.FLOAT).addNullableField("f6", Schema.FieldType.DOUBLE).addNullableField("f7", Schema.FieldType.DECIMAL).addNullableField("f8", Schema.FieldType.BOOLEAN).addNullableField("f9", Schema.FieldType.BYTES).addNullableField("f10", Schema.FieldType.STRING).build();
        Map<String, RelDataType> fields = this.calciteRowTypeFields(schema);
        Assert.assertEquals((long)10L, (long)fields.size());
        fields.values().forEach(x -> Assert.assertTrue((boolean)x.isNullable()));
        Assert.assertEquals((Object)((Object)SqlTypeName.TINYINT), (Object)((Object)fields.get("f1").getSqlTypeName()));
        Assert.assertEquals((Object)((Object)SqlTypeName.SMALLINT), (Object)((Object)fields.get("f2").getSqlTypeName()));
        Assert.assertEquals((Object)((Object)SqlTypeName.INTEGER), (Object)((Object)fields.get("f3").getSqlTypeName()));
        Assert.assertEquals((Object)((Object)SqlTypeName.BIGINT), (Object)((Object)fields.get("f4").getSqlTypeName()));
        Assert.assertEquals((Object)((Object)SqlTypeName.FLOAT), (Object)((Object)fields.get("f5").getSqlTypeName()));
        Assert.assertEquals((Object)((Object)SqlTypeName.DOUBLE), (Object)((Object)fields.get("f6").getSqlTypeName()));
        Assert.assertEquals((Object)((Object)SqlTypeName.DECIMAL), (Object)((Object)fields.get("f7").getSqlTypeName()));
        Assert.assertEquals((Object)((Object)SqlTypeName.BOOLEAN), (Object)((Object)fields.get("f8").getSqlTypeName()));
        Assert.assertEquals((Object)((Object)SqlTypeName.VARBINARY), (Object)((Object)fields.get("f9").getSqlTypeName()));
        Assert.assertEquals((Object)((Object)SqlTypeName.VARCHAR), (Object)((Object)fields.get("f10").getSqlTypeName()));
    }

    @Test
    public void testRoundTripBeamSchema() {
        Schema schema = Schema.builder().addField("f1", Schema.FieldType.BYTE).addField("f2", Schema.FieldType.INT16).addField("f3", Schema.FieldType.INT32).addField("f4", Schema.FieldType.INT64).addField("f5", Schema.FieldType.FLOAT).addField("f6", Schema.FieldType.DOUBLE).addField("f7", Schema.FieldType.DECIMAL).addField("f8", Schema.FieldType.BOOLEAN).addField("f9", Schema.FieldType.BYTES).addField("f10", Schema.FieldType.STRING).build();
        Schema out = CalciteUtils.toSchema((RelDataType)CalciteUtils.toCalciteRowType((Schema)schema, (RelDataTypeFactory)this.dataTypeFactory));
        Assert.assertEquals((Object)schema, (Object)out);
    }

    @Test
    public void testRoundTripBeamNullableSchema() {
        Schema schema = Schema.builder().addNullableField("f1", Schema.FieldType.BYTE).addNullableField("f2", Schema.FieldType.INT16).addNullableField("f3", Schema.FieldType.INT32).addNullableField("f4", Schema.FieldType.INT64).addNullableField("f5", Schema.FieldType.FLOAT).addNullableField("f6", Schema.FieldType.DOUBLE).addNullableField("f7", Schema.FieldType.DECIMAL).addNullableField("f8", Schema.FieldType.BOOLEAN).addNullableField("f9", Schema.FieldType.BYTES).addNullableField("f10", Schema.FieldType.STRING).build();
        Schema out = CalciteUtils.toSchema((RelDataType)CalciteUtils.toCalciteRowType((Schema)schema, (RelDataTypeFactory)this.dataTypeFactory));
        Assert.assertEquals((Object)schema, (Object)out);
    }
}

