/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.schema;

import java.math.BigDecimal;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.values.Row;
import org.joda.time.DateTime;
import org.junit.Test;

public class BeamSqlRowCoderTest {
    @Test
    public void encodeAndDecode() throws Exception {
        RelDataType relDataType = new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT).builder().add("col_tinyint", SqlTypeName.TINYINT).add("col_smallint", SqlTypeName.SMALLINT).add("col_integer", SqlTypeName.INTEGER).add("col_bigint", SqlTypeName.BIGINT).add("col_float", SqlTypeName.FLOAT).add("col_double", SqlTypeName.DOUBLE).add("col_decimal", SqlTypeName.DECIMAL).add("col_string_varchar", SqlTypeName.VARCHAR).add("col_time", SqlTypeName.TIME).add("col_timestamp", SqlTypeName.TIMESTAMP).add("col_boolean", SqlTypeName.BOOLEAN).build();
        Schema beamSchema = CalciteUtils.toSchema((RelDataType)relDataType);
        Row row = Row.withSchema((Schema)beamSchema).addValues(new Object[]{Byte.valueOf("1"), Short.valueOf("1"), 1, 1L, Float.valueOf(1.1f), 1.1, BigDecimal.ZERO, "hello", DateTime.now(), DateTime.now(), true}).build();
        SchemaCoder coder = SchemaCoder.of((Schema)beamSchema, (SerializableFunction)SerializableFunctions.identity(), (SerializableFunction)SerializableFunctions.identity());
        CoderProperties.coderDecodeEncodeEqual((Coder)coder, (Object)row);
    }
}

