/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.mock.MockedBoundedTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class BeamUnionRelTest
extends BaseRelTest {
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();

    @BeforeClass
    public static void prepare() {
        BeamUnionRelTest.registerTable("ORDER_DETAILS", (BeamSqlTable)MockedBoundedTable.of(Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DOUBLE, "price").addRows(1L, 1, 1.0, 2L, 2, 2.0));
    }

    @Test
    public void testUnion() throws Exception {
        String sql = "SELECT  order_id, site_id, price FROM ORDER_DETAILS  UNION SELECT  order_id, site_id, price FROM ORDER_DETAILS ";
        PCollection<Row> rows = BeamUnionRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DOUBLE, "price").addRows(1L, 1, 1.0, 2L, 2, 2.0).getRows());
        this.pipeline.run();
    }

    @Test
    public void testUnionAll() throws Exception {
        String sql = "SELECT  order_id, site_id, price FROM ORDER_DETAILS UNION ALL  SELECT order_id, site_id, price FROM ORDER_DETAILS";
        PCollection<Row> rows = BeamUnionRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DOUBLE, "price").addRows(1L, 1, 1.0, 1L, 1, 1.0, 2L, 2, 2.0, 2L, 2, 2.0).getRows());
        this.pipeline.run();
    }
}

