/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.BeamSqlSeekableTable;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.impl.schema.BaseBeamTable;
import org.apache.beam.sdk.extensions.sql.impl.transform.BeamSqlOutputToConsoleFn;
import org.apache.beam.sdk.extensions.sql.mock.MockedBoundedTable;
import org.apache.beam.sdk.extensions.sql.mock.MockedUnboundedTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class BeamJoinRelUnboundedVsBoundedTest
extends BaseRelTest {
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();
    public static final DateTime FIRST_DATE = new DateTime(1L);
    public static final DateTime SECOND_DATE = new DateTime(3600001L);
    public static final DateTime THIRD_DATE = new DateTime(7200002L);
    private static final Duration WINDOW_SIZE = Duration.standardHours((long)1L);

    @BeforeClass
    public static void prepare() {
        BeamJoinRelUnboundedVsBoundedTest.registerTable("ORDER_DETAILS", (BeamSqlTable)MockedUnboundedTable.of(Schema.FieldType.INT32, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.INT32, "price", Schema.FieldType.DATETIME, "order_time").timestampColumnIndex(3).addRows(Duration.ZERO, 1, 1, 1, FIRST_DATE, 1, 2, 2, FIRST_DATE).addRows(WINDOW_SIZE.plus((ReadableDuration)Duration.standardSeconds((long)1L)), 2, 2, 3, SECOND_DATE, 2, 3, 3, SECOND_DATE, 1, 2, 3, FIRST_DATE).addRows(WINDOW_SIZE.plus((ReadableDuration)WINDOW_SIZE).plus((ReadableDuration)Duration.standardSeconds((long)1L)), 3, 3, 3, THIRD_DATE, 2, 2, 3, SECOND_DATE));
        BeamJoinRelUnboundedVsBoundedTest.registerTable("ORDER_DETAILS1", (BeamSqlTable)MockedBoundedTable.of(Schema.FieldType.INT32, "order_id", Schema.FieldType.STRING, "buyer").addRows(1, "james", 2, "bond"));
        BeamJoinRelUnboundedVsBoundedTest.registerTable("SITE_LKP", (BeamSqlTable)new SiteLookupTable(TestUtils.buildBeamSqlSchema(Schema.FieldType.INT32, "site_id", Schema.FieldType.STRING, "site_name")));
    }

    @Test
    public void testInnerJoin_unboundedTableOnTheLeftSide() throws Exception {
        String sql = "SELECT o1.order_id, o1.sum_site_id, o2.buyer FROM (select order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS           GROUP BY order_id, TUMBLE(order_time, INTERVAL '1' HOUR)) o1  JOIN  ORDER_DETAILS1 o2  on  o1.order_id=o2.order_id";
        PCollection<Row> rows = BeamJoinRelUnboundedVsBoundedTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that((PCollection)((PCollection)rows.apply((PTransform)ParDo.of((DoFn)new TestUtils.BeamSqlRow2StringDoFn())))).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT32, "order_id", Schema.FieldType.INT32, "sum_site_id", Schema.FieldType.STRING, "buyer").addRows(1, 3, "james", 2, 5, "bond").getStringRows());
        this.pipeline.run();
    }

    @Test
    public void testInnerJoin_boundedTableOnTheLeftSide() throws Exception {
        String sql = "SELECT o1.order_id, o1.sum_site_id, o2.buyer FROM  ORDER_DETAILS1 o2  JOIN (select order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS           GROUP BY order_id, TUMBLE(order_time, INTERVAL '1' HOUR)) o1  on  o1.order_id=o2.order_id";
        PCollection<Row> rows = BeamJoinRelUnboundedVsBoundedTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that((PCollection)((PCollection)rows.apply((PTransform)ParDo.of((DoFn)new TestUtils.BeamSqlRow2StringDoFn())))).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT32, "order_id", Schema.FieldType.INT32, "sum_site_id", Schema.FieldType.STRING, "buyer").addRows(1, 3, "james", 2, 5, "bond").getStringRows());
        this.pipeline.run();
    }

    @Test
    public void testLeftOuterJoin() throws Exception {
        String sql = "SELECT o1.order_id, o1.sum_site_id, o2.buyer FROM (select order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS           GROUP BY order_id, TUMBLE(order_time, INTERVAL '1' HOUR)) o1  LEFT OUTER JOIN  ORDER_DETAILS1 o2  on  o1.order_id=o2.order_id";
        PCollection<Row> rows = BeamJoinRelUnboundedVsBoundedTest.compilePipeline(sql, (Pipeline)this.pipeline);
        rows.apply((PTransform)ParDo.of((DoFn)new BeamSqlOutputToConsoleFn("helloworld")));
        PAssert.that((PCollection)((PCollection)rows.apply((PTransform)ParDo.of((DoFn)new TestUtils.BeamSqlRow2StringDoFn())))).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.builder().addField("order_id", Schema.FieldType.INT32).addField("sum_site_id", Schema.FieldType.INT32).addNullableField("buyer", Schema.FieldType.STRING).build()).addRows(1, 3, "james", 2, 5, "bond", 3, 3, null).getStringRows());
        this.pipeline.run();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testLeftOuterJoinError() throws Exception {
        String sql = "SELECT o1.order_id, o1.sum_site_id, o2.buyer FROM  ORDER_DETAILS1 o2  LEFT OUTER JOIN (select order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS           GROUP BY order_id, TUMBLE(order_time, INTERVAL '1' HOUR)) o1  on  o1.order_id=o2.order_id";
        this.pipeline.enableAbandonedNodeEnforcement(false);
        BeamJoinRelUnboundedVsBoundedTest.compilePipeline(sql, (Pipeline)this.pipeline);
        this.pipeline.run();
    }

    @Test
    public void testRightOuterJoin() throws Exception {
        String sql = "SELECT o1.order_id, o1.sum_site_id, o2.buyer FROM  ORDER_DETAILS1 o2  RIGHT OUTER JOIN (select order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS           GROUP BY order_id, TUMBLE(order_time, INTERVAL '1' HOUR)) o1  on  o1.order_id=o2.order_id";
        PCollection<Row> rows = BeamJoinRelUnboundedVsBoundedTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that((PCollection)((PCollection)rows.apply((PTransform)ParDo.of((DoFn)new TestUtils.BeamSqlRow2StringDoFn())))).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.builder().addField("order_id", Schema.FieldType.INT32).addField("sum_site_id", Schema.FieldType.INT32).addNullableField("buyer", Schema.FieldType.STRING).build()).addRows(1, 3, "james", 2, 5, "bond", 3, 3, null).getStringRows());
        this.pipeline.run();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRightOuterJoinError() throws Exception {
        String sql = "SELECT o1.order_id, o1.sum_site_id, o2.buyer FROM (select order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS           GROUP BY order_id, TUMBLE(order_time, INTERVAL '1' HOUR)) o1  RIGHT OUTER JOIN  ORDER_DETAILS1 o2  on  o1.order_id=o2.order_id";
        this.pipeline.enableAbandonedNodeEnforcement(false);
        BeamJoinRelUnboundedVsBoundedTest.compilePipeline(sql, (Pipeline)this.pipeline);
        this.pipeline.run();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testFullOuterJoinError() throws Exception {
        String sql = "SELECT o1.order_id, o1.sum_site_id, o2.buyer FROM  ORDER_DETAILS1 o2  FULL OUTER JOIN (select order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS           GROUP BY order_id, TUMBLE(order_time, INTERVAL '1' HOUR)) o1  on  o1.order_id=o2.order_id";
        this.pipeline.enableAbandonedNodeEnforcement(false);
        BeamJoinRelUnboundedVsBoundedTest.compilePipeline(sql, (Pipeline)this.pipeline);
        this.pipeline.run();
    }

    @Test
    public void testJoinAsLookup() throws Exception {
        String sql = "SELECT o1.order_id, o2.site_name FROM  ORDER_DETAILS o1  JOIN SITE_LKP o2  on  o1.site_id=o2.site_id  WHERE o1.site_id=1";
        PCollection<Row> rows = BeamJoinRelUnboundedVsBoundedTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that((PCollection)((PCollection)rows.apply((PTransform)ParDo.of((DoFn)new TestUtils.BeamSqlRow2StringDoFn())))).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT32, "order_id", Schema.FieldType.STRING, "site_name").addRows(1, "SITE1").getStringRows());
        this.pipeline.run();
    }

    public static class SiteLookupTable
    extends BaseBeamTable
    implements BeamSqlSeekableTable {
        public SiteLookupTable(Schema schema) {
            super(schema);
        }

        public PCollection<Row> buildIOReader(PBegin begin) {
            throw new UnsupportedOperationException();
        }

        public POutput buildIOWriter(PCollection<Row> input) {
            throw new UnsupportedOperationException();
        }

        public List<Row> seekRow(Row lookupSubRow) {
            return Arrays.asList(Row.withSchema((Schema)this.getSchema()).addValues(new Object[]{1, "SITE1"}).build());
        }
    }
}

