/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.impl.rel.CheckSize;
import org.apache.beam.sdk.extensions.sql.mock.MockedBoundedTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class BeamIntersectRelTest
extends BaseRelTest {
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();

    @BeforeClass
    public static void prepare() {
        BeamIntersectRelTest.registerTable("ORDER_DETAILS1", (BeamSqlTable)MockedBoundedTable.of(Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DOUBLE, "price").addRows(1L, 1, 1.0, 1L, 1, 1.0, 2L, 2, 2.0, 4L, 4, 4.0));
        BeamIntersectRelTest.registerTable("ORDER_DETAILS2", (BeamSqlTable)MockedBoundedTable.of(Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DOUBLE, "price").addRows(1L, 1, 1.0, 2L, 2, 2.0, 3L, 3, 3.0));
    }

    @Test
    public void testIntersect() throws Exception {
        String sql = "";
        sql = sql + "SELECT order_id, site_id, price FROM ORDER_DETAILS1  INTERSECT SELECT order_id, site_id, price FROM ORDER_DETAILS2 ";
        PCollection<Row> rows = BeamIntersectRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DOUBLE, "price").addRows(1L, 1, 1.0, 2L, 2, 2.0).getRows());
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testIntersectAll() throws Exception {
        String sql = "";
        sql = sql + "SELECT order_id, site_id, price FROM ORDER_DETAILS1  INTERSECT ALL SELECT order_id, site_id, price FROM ORDER_DETAILS2 ";
        PCollection<Row> rows = BeamIntersectRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).satisfies((SerializableFunction)new CheckSize(3));
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DOUBLE, "price").addRows(1L, 1, 1.0, 1L, 1, 1.0, 2L, 2, 2.0).getRows());
        this.pipeline.run();
    }
}

