/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.math.BigDecimal;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.Enumerable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.Enumerator;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptTable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamEnumerableConverter;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamIOSinkRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamValuesRel;
import org.apache.beam.sdk.extensions.sql.impl.schema.BaseBeamTable;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.junit.Assert;
import org.junit.Test;

public class BeamEnumerableConverterTest {
    static final JavaTypeFactory TYPE_FACTORY = new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
    static RexBuilder rexBuilder = new RexBuilder(TYPE_FACTORY);
    static PipelineOptions options = PipelineOptionsFactory.create();
    static RelOptCluster cluster = RelOptCluster.create(new VolcanoPlanner(), rexBuilder);

    @Test
    public void testToEnumerable_collectSingle() {
        Schema schema = Schema.builder().addInt64Field("id").build();
        RelDataType type = CalciteUtils.toCalciteRowType((Schema)schema, (RelDataTypeFactory)TYPE_FACTORY);
        ImmutableList<ImmutableList<RexLiteral>> tuples = ImmutableList.of(ImmutableList.of(rexBuilder.makeBigintLiteral(BigDecimal.ZERO)));
        BeamValuesRel node = new BeamValuesRel(cluster, type, tuples, null);
        Enumerable enumerable = BeamEnumerableConverter.toEnumerable((PipelineOptions)options, (BeamRelNode)node);
        Enumerator enumerator = enumerable.enumerator();
        Assert.assertTrue((boolean)enumerator.moveNext());
        Assert.assertEquals((Object)0L, enumerator.current());
        Assert.assertFalse((boolean)enumerator.moveNext());
        enumerator.close();
    }

    @Test
    public void testToEnumerable_collectMultiple() {
        Schema schema = Schema.builder().addInt64Field("id").addInt64Field("otherid").build();
        RelDataType type = CalciteUtils.toCalciteRowType((Schema)schema, (RelDataTypeFactory)TYPE_FACTORY);
        ImmutableList<ImmutableList<RexLiteral>> tuples = ImmutableList.of(ImmutableList.of(rexBuilder.makeBigintLiteral(BigDecimal.ZERO), rexBuilder.makeBigintLiteral(BigDecimal.ONE)));
        BeamValuesRel node = new BeamValuesRel(cluster, type, tuples, null);
        Enumerable enumerable = BeamEnumerableConverter.toEnumerable((PipelineOptions)options, (BeamRelNode)node);
        Enumerator enumerator = enumerable.enumerator();
        Assert.assertTrue((boolean)enumerator.moveNext());
        Object[] row = (Object[])enumerator.current();
        Assert.assertEquals((long)2L, (long)row.length);
        Assert.assertEquals((Object)0L, (Object)row[0]);
        Assert.assertEquals((Object)1L, (Object)row[1]);
        Assert.assertFalse((boolean)enumerator.moveNext());
        enumerator.close();
    }

    @Test
    public void testToEnumerable_count() {
        Schema schema = Schema.builder().addInt64Field("id").build();
        RelDataType type = CalciteUtils.toCalciteRowType((Schema)schema, (RelDataTypeFactory)TYPE_FACTORY);
        ImmutableList<ImmutableList<RexLiteral>> tuples = ImmutableList.of(ImmutableList.of(rexBuilder.makeBigintLiteral(BigDecimal.ZERO)), ImmutableList.of(rexBuilder.makeBigintLiteral(BigDecimal.ONE)));
        BeamIOSinkRel node = new BeamIOSinkRel(cluster, (RelOptTable)RelOptTableImpl.create(null, type, ImmutableList.of(), null), null, (RelNode)new BeamValuesRel(cluster, type, tuples, null), null, null, null, false, (BeamSqlTable)new FakeTable(), null);
        Enumerable enumerable = BeamEnumerableConverter.toEnumerable((PipelineOptions)options, (BeamRelNode)node);
        Enumerator enumerator = enumerable.enumerator();
        Assert.assertTrue((boolean)enumerator.moveNext());
        Assert.assertEquals((Object)2L, enumerator.current());
        Assert.assertFalse((boolean)enumerator.moveNext());
        enumerator.close();
    }

    private static class FakeTable
    extends BaseBeamTable {
        public FakeTable() {
            super(null);
        }

        public PCollection<Row> buildIOReader(PBegin begin) {
            return null;
        }

        public POutput buildIOWriter(PCollection<Row> input) {
            input.apply((PTransform)ParDo.of((DoFn)new DoFn<Row, Void>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext context) {
                }
            }));
            return PDone.in((Pipeline)input.getPipeline());
        }
    }
}

