/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.parser;

import com.pholser.junit.quickcheck.From;
import com.pholser.junit.quickcheck.Property;
import com.pholser.junit.quickcheck.runner.JUnitQuickcheck;
import java.util.stream.Collectors;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.parser.SqlParseException;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestTableProvider;
import org.apache.beam.sdk.extensions.sql.utils.QuickCheckGenerators;
import org.apache.beam.sdk.schemas.Schema;
import org.junit.Assert;
import org.junit.runner.RunWith;

@RunWith(value=JUnitQuickcheck.class)
public class BeamDDLNestedTypesTest {
    @Property
    public void supportsNestedTypes(@From(value=QuickCheckGenerators.AnyFieldType.class) Schema.FieldType generatedFieldType) throws SqlParseException {
        String fieldTypeDeclaration = this.unparse(generatedFieldType);
        Table table = this.executeCreateTableWith(fieldTypeDeclaration);
        Schema expectedSchema = this.newSimpleSchemaWith(generatedFieldType);
        Assert.assertEquals((Object)expectedSchema, (Object)table.getSchema());
    }

    @Property
    public void supportsPrimitiveTypes(@From(value=QuickCheckGenerators.PrimitiveTypes.class) Schema.FieldType fieldType) throws SqlParseException {
        String fieldTypeDeclaration = this.unparse(fieldType);
        Table table = this.executeCreateTableWith(fieldTypeDeclaration);
        Schema expectedSchema = this.newSimpleSchemaWith(fieldType);
        Assert.assertEquals((Object)expectedSchema, (Object)table.getSchema());
    }

    private Table executeCreateTableWith(String fieldType) throws SqlParseException {
        String createTable = "create table tablename ( fieldName " + fieldType + " ) TYPE 'text' LOCATION '/home/admin/person'\n";
        System.out.println(createTable);
        TestTableProvider tableProvider = new TestTableProvider();
        BeamSqlEnv env = BeamSqlEnv.withTableProvider((TableProvider)tableProvider);
        env.executeDdl(createTable);
        return (Table)tableProvider.getTables().get("tablename");
    }

    private Schema newSimpleSchemaWith(Schema.FieldType fieldType) {
        return Schema.builder().addNullableField("fieldName", fieldType).build();
    }

    private String unparse(Schema.FieldType fieldType) {
        if (fieldType.getTypeName().isMapType()) {
            return this.unparseMap(fieldType);
        }
        if (fieldType.getTypeName().isCollectionType()) {
            return this.unparseArray(fieldType);
        }
        if (fieldType.getTypeName().isCompositeType()) {
            return this.unparseRow(fieldType);
        }
        return this.unparsePrimitive(fieldType);
    }

    private String unparsePrimitive(Schema.FieldType fieldType) {
        return CalciteUtils.toSqlTypeName((Schema.FieldType)fieldType).getName();
    }

    private String unparseArray(Schema.FieldType fieldType) {
        return "ARRAY<" + this.unparse(fieldType.getCollectionElementType()) + ">";
    }

    private String unparseMap(Schema.FieldType fieldType) {
        return "MAP<" + this.unparse(fieldType.getMapKeyType()) + ", " + this.unparse(fieldType.getMapValueType()) + ">";
    }

    private String unparseRow(Schema.FieldType fieldType) {
        return "ROW<" + fieldType.getRowSchema().getFields().stream().map(field -> field.getName() + " " + this.unparse(field.getType())).collect(Collectors.joining(",")) + ">";
    }
}

