/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.row;

import java.util.Arrays;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironments;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.row.BeamSqlFieldAccessExpression;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BeamSqlFieldAccessExpressionTest {
    private static final Row NULL_ROW = null;
    private static final BoundedWindow NULL_WINDOW = null;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testAccessesFieldOfArray() {
        BeamSqlPrimitive targetArray = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.ARRAY, Arrays.asList("aaa", "bbb", "ccc"));
        BeamSqlFieldAccessExpression arrayExpression = new BeamSqlFieldAccessExpression((BeamSqlExpression)targetArray, 1, SqlTypeName.VARCHAR);
        Assert.assertEquals((Object)"bbb", (Object)arrayExpression.evaluate(NULL_ROW, NULL_WINDOW, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testAccessesFieldOfRow() {
        Schema schema = Schema.builder().addStringField("f_string1").addStringField("f_string2").addStringField("f_string3").build();
        BeamSqlPrimitive targetRow = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.ROW, (Object)Row.withSchema((Schema)schema).addValues(new Object[]{"aa", "bb", "cc"}).build());
        BeamSqlFieldAccessExpression arrayExpression = new BeamSqlFieldAccessExpression((BeamSqlExpression)targetRow, 1, SqlTypeName.VARCHAR);
        Assert.assertEquals((Object)"bb", (Object)arrayExpression.evaluate(NULL_ROW, NULL_WINDOW, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testThrowsForUnsupportedType() {
        BeamSqlPrimitive targetRow = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)5);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("unsupported type");
        new BeamSqlFieldAccessExpression((BeamSqlExpression)targetRow, 1, SqlTypeName.VARCHAR).evaluate(NULL_ROW, NULL_WINDOW, BeamSqlExpressionEnvironments.empty()).getValue();
    }
}

