/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.reinterpret;

import java.math.BigDecimal;
import java.util.HashSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.reinterpret.ReinterpretConversion;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.reinterpret.Reinterpreter;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;

public class ReinterpreterTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testBuilderCreatesInstance() {
        Reinterpreter reinterpreter = this.newReinterpreter();
        Assert.assertNotNull((Object)reinterpreter);
    }

    @Test
    public void testBuilderThrowsWithoutConverters() {
        this.thrown.expect(IllegalArgumentException.class);
        Reinterpreter.builder().build();
    }

    @Test
    public void testCanConvertBetweenSupportedTypes() {
        Reinterpreter reinterpreter = Reinterpreter.builder().withConversion(this.mockConversion(SqlTypeName.SYMBOL, SqlTypeName.SMALLINT, SqlTypeName.DATE)).withConversion(this.mockConversion(SqlTypeName.INTEGER, SqlTypeName.FLOAT)).build();
        Assert.assertTrue((boolean)reinterpreter.canConvert(SqlTypeName.SMALLINT, SqlTypeName.SYMBOL));
        Assert.assertTrue((boolean)reinterpreter.canConvert(SqlTypeName.DATE, SqlTypeName.SYMBOL));
        Assert.assertTrue((boolean)reinterpreter.canConvert(SqlTypeName.FLOAT, SqlTypeName.INTEGER));
    }

    @Test
    public void testCannotConvertFromUnsupportedTypes() {
        Reinterpreter reinterpreter = Reinterpreter.builder().withConversion(this.mockConversion(SqlTypeName.SYMBOL, SqlTypeName.SMALLINT, SqlTypeName.DATE)).withConversion(this.mockConversion(SqlTypeName.INTEGER, SqlTypeName.FLOAT)).build();
        HashSet<SqlTypeName> unsupportedTypes = new HashSet<SqlTypeName>(SqlTypeName.ALL_TYPES);
        unsupportedTypes.removeAll(Sets.newSet((Object[])new SqlTypeName[]{SqlTypeName.DATE, SqlTypeName.SMALLINT, SqlTypeName.FLOAT}));
        for (SqlTypeName unsupportedType : unsupportedTypes) {
            Assert.assertFalse((boolean)reinterpreter.canConvert(unsupportedType, SqlTypeName.DATE));
            Assert.assertFalse((boolean)reinterpreter.canConvert(unsupportedType, SqlTypeName.INTEGER));
        }
    }

    @Test
    public void testCannotConvertToUnsupportedTypes() {
        Reinterpreter reinterpreter = Reinterpreter.builder().withConversion(this.mockConversion(SqlTypeName.SYMBOL, SqlTypeName.SMALLINT, SqlTypeName.DATE)).withConversion(this.mockConversion(SqlTypeName.INTEGER, SqlTypeName.FLOAT)).build();
        HashSet<SqlTypeName> unsupportedTypes = new HashSet<SqlTypeName>(SqlTypeName.ALL_TYPES);
        unsupportedTypes.removeAll(Sets.newSet((Object[])new SqlTypeName[]{SqlTypeName.SYMBOL, SqlTypeName.INTEGER}));
        for (SqlTypeName unsupportedType : unsupportedTypes) {
            Assert.assertFalse((boolean)reinterpreter.canConvert(SqlTypeName.SMALLINT, unsupportedType));
            Assert.assertFalse((boolean)reinterpreter.canConvert(SqlTypeName.DATE, unsupportedType));
            Assert.assertFalse((boolean)reinterpreter.canConvert(SqlTypeName.FLOAT, unsupportedType));
        }
    }

    @Test
    public void testConvert() {
        DateTime date = new DateTime(12345L);
        BeamSqlPrimitive stringPrimitive = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"hello");
        BeamSqlPrimitive datePrimitive = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DATE, (Object)date);
        ReinterpretConversion mockConversion = (ReinterpretConversion)Mockito.mock(ReinterpretConversion.class);
        ((ReinterpretConversion)Mockito.doReturn((Object)Sets.newSet((Object[])new SqlTypeName[]{SqlTypeName.VARCHAR})).when((Object)mockConversion)).from();
        ((ReinterpretConversion)Mockito.doReturn((Object)((Object)SqlTypeName.DATE)).when((Object)mockConversion)).to();
        ((ReinterpretConversion)Mockito.doReturn((Object)datePrimitive).when((Object)mockConversion)).convert((BeamSqlPrimitive)Matchers.same((Object)stringPrimitive));
        Reinterpreter reinterpreter = Reinterpreter.builder().withConversion(mockConversion).build();
        BeamSqlPrimitive converted = reinterpreter.convert(SqlTypeName.DATE, stringPrimitive);
        Assert.assertSame((Object)datePrimitive, (Object)converted);
        ((ReinterpretConversion)Mockito.verify((Object)mockConversion)).convert((BeamSqlPrimitive)Matchers.same((Object)stringPrimitive));
    }

    @Test
    public void testConvertThrowsForUnsupportedFromType() {
        this.thrown.expect(UnsupportedOperationException.class);
        BeamSqlPrimitive intervalPrimitive = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTERVAL_DAY, (Object)new BigDecimal(2));
        Reinterpreter reinterpreter = this.newReinterpreter();
        reinterpreter.convert(SqlTypeName.DATE, intervalPrimitive);
    }

    @Test
    public void testConvertThrowsForUnsupportedToType() {
        this.thrown.expect(UnsupportedOperationException.class);
        BeamSqlPrimitive stringPrimitive = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"hello");
        Reinterpreter reinterpreter = this.newReinterpreter();
        reinterpreter.convert(SqlTypeName.INTERVAL_DAY, stringPrimitive);
    }

    private Reinterpreter newReinterpreter() {
        return Reinterpreter.builder().withConversion(this.mockConversion(SqlTypeName.DATE, SqlTypeName.SMALLINT, SqlTypeName.VARCHAR)).build();
    }

    private ReinterpretConversion mockConversion(SqlTypeName convertTo, SqlTypeName ... convertFrom) {
        ReinterpretConversion conversion = (ReinterpretConversion)Mockito.mock(ReinterpretConversion.class);
        ((ReinterpretConversion)Mockito.doReturn((Object)Sets.newSet((Object[])convertFrom)).when((Object)conversion)).from();
        ((ReinterpretConversion)Mockito.doReturn((Object)((Object)convertTo)).when((Object)conversion)).to();
        return conversion;
    }
}

