/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.reinterpret;

import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.Function;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.reinterpret.ReinterpretConversion;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class ReinterpretConversionTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testNewInstanceProperties() {
        ImmutableSet<SqlTypeName> from = ImmutableSet.of(SqlTypeName.FLOAT, SqlTypeName.TIME);
        SqlTypeName to = SqlTypeName.BOOLEAN;
        Function mockConversionFunction = (Function)Mockito.mock(Function.class);
        ReinterpretConversion conversion = ReinterpretConversion.builder().from(from).to(to).convert(mockConversionFunction).build();
        Assert.assertEquals(from, (Object)conversion.from());
        Assert.assertEquals((Object)((Object)to), (Object)((Object)conversion.to()));
    }

    @Test
    public void testConvert() {
        BeamSqlPrimitive integerPrimitive = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)3);
        BeamSqlPrimitive booleanPrimitive = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BOOLEAN, (Object)true);
        Function mockConversionFunction = (Function)Mockito.mock(Function.class);
        ((Function)Mockito.doReturn((Object)booleanPrimitive).when((Object)mockConversionFunction)).apply((BeamSqlPrimitive)Matchers.same((Object)integerPrimitive));
        ReinterpretConversion conversion = ReinterpretConversion.builder().from(SqlTypeName.INTEGER).to(SqlTypeName.BOOLEAN).convert(mockConversionFunction).build();
        BeamSqlPrimitive conversionResult = conversion.convert(integerPrimitive);
        Assert.assertSame((Object)booleanPrimitive, (Object)conversionResult);
        ((Function)Mockito.verify((Object)mockConversionFunction)).apply((BeamSqlPrimitive)Matchers.same((Object)integerPrimitive));
    }

    @Test
    public void testBuilderThrowsWithoutFrom() {
        this.thrown.expect(IllegalArgumentException.class);
        ReinterpretConversion.builder().to(SqlTypeName.BOOLEAN).convert((Function)Mockito.mock(Function.class)).build();
    }

    @Test
    public void testBuilderThrowsWihtoutTo() {
        this.thrown.expect(IllegalArgumentException.class);
        ReinterpretConversion.builder().from(SqlTypeName.BOOLEAN).convert((Function)Mockito.mock(Function.class)).build();
    }

    @Test
    public void testBuilderThrowsWihtoutConversionFunction() {
        this.thrown.expect(IllegalArgumentException.class);
        ReinterpretConversion.builder().from(SqlTypeName.BOOLEAN).to(SqlTypeName.SMALLINT).build();
    }

    @Test
    public void testConvertThrowsForUnsupportedInput() {
        this.thrown.expect(IllegalArgumentException.class);
        ReinterpretConversion conversion = ReinterpretConversion.builder().from(SqlTypeName.DATE).to(SqlTypeName.BOOLEAN).convert((Function)Mockito.mock(Function.class)).build();
        conversion.convert(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)3));
    }
}

