/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.reinterpret;

import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.reinterpret.IntegerReinterpretConversions;
import org.junit.Assert;
import org.junit.Test;

public class IntegerReinterpretConversionsTest {
    private static final BeamSqlPrimitive TINYINT_PRIMITIVE_5 = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.TINYINT, (Object)5);
    private static final BeamSqlPrimitive SMALLINT_PRIMITIVE_6 = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.SMALLINT, (Object)6);
    private static final BeamSqlPrimitive INTEGER_PRIMITIVE_8 = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)8);
    private static final BeamSqlPrimitive BIGINT_PRIMITIVE_15 = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)15L);

    @Test
    public void testTinyIntToBigint() {
        BeamSqlPrimitive conversionResultPrimitive = IntegerReinterpretConversions.INTEGER_TYPES_TO_BIGINT.convert(TINYINT_PRIMITIVE_5);
        Assert.assertEquals((Object)((Object)SqlTypeName.BIGINT), (Object)((Object)conversionResultPrimitive.getOutputType()));
        Assert.assertEquals((long)5L, (long)conversionResultPrimitive.getLong());
    }

    @Test
    public void testSmallIntToBigint() {
        BeamSqlPrimitive conversionResultPrimitive = IntegerReinterpretConversions.INTEGER_TYPES_TO_BIGINT.convert(SMALLINT_PRIMITIVE_6);
        Assert.assertEquals((Object)((Object)SqlTypeName.BIGINT), (Object)((Object)conversionResultPrimitive.getOutputType()));
        Assert.assertEquals((long)6L, (long)conversionResultPrimitive.getLong());
    }

    @Test
    public void testIntegerToBigint() {
        BeamSqlPrimitive conversionResultPrimitive = IntegerReinterpretConversions.INTEGER_TYPES_TO_BIGINT.convert(INTEGER_PRIMITIVE_8);
        Assert.assertEquals((Object)((Object)SqlTypeName.BIGINT), (Object)((Object)conversionResultPrimitive.getOutputType()));
        Assert.assertEquals((long)8L, (long)conversionResultPrimitive.getLong());
    }

    @Test
    public void testBigintToBigint() {
        BeamSqlPrimitive conversionResultPrimitive = IntegerReinterpretConversions.INTEGER_TYPES_TO_BIGINT.convert(BIGINT_PRIMITIVE_15);
        Assert.assertEquals((Object)((Object)SqlTypeName.BIGINT), (Object)((Object)conversionResultPrimitive.getOutputType()));
        Assert.assertEquals((long)15L, (long)conversionResultPrimitive.getLong());
    }
}

