/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.reinterpret;

import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.reinterpret.DatetimeReinterpretConversions;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class DatetimeReinterpretConversionsTest {
    private static final long DATE_LONG = 1000L;
    private static final DateTime DATE = new DateTime(1000L);
    private static final DateTime TIME = new DateTime().withDate(2017, 8, 9);
    private static final BeamSqlPrimitive DATE_PRIMITIVE = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DATE, (Object)DATE);
    private static final BeamSqlPrimitive TIME_PRIMITIVE = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.TIME, (Object)TIME);
    private static final BeamSqlPrimitive TIMESTAMP_PRIMITIVE = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.TIMESTAMP, (Object)DATE);

    @Test
    public void testTimeToBigint() {
        BeamSqlPrimitive conversionResultPrimitive = DatetimeReinterpretConversions.TIME_TO_BIGINT.convert(TIME_PRIMITIVE);
        Assert.assertEquals((Object)((Object)SqlTypeName.BIGINT), (Object)((Object)conversionResultPrimitive.getOutputType()));
        Assert.assertEquals((long)TIME.getMillis(), (long)conversionResultPrimitive.getLong());
    }

    @Test
    public void testDateToBigint() {
        BeamSqlPrimitive conversionResultPrimitive = DatetimeReinterpretConversions.DATE_TYPES_TO_BIGINT.convert(DATE_PRIMITIVE);
        Assert.assertEquals((Object)((Object)SqlTypeName.BIGINT), (Object)((Object)conversionResultPrimitive.getOutputType()));
        Assert.assertEquals((long)1000L, (long)conversionResultPrimitive.getLong());
    }

    @Test
    public void testTimestampToBigint() {
        BeamSqlPrimitive conversionResultPrimitive = DatetimeReinterpretConversions.DATE_TYPES_TO_BIGINT.convert(TIMESTAMP_PRIMITIVE);
        Assert.assertEquals((Object)((Object)SqlTypeName.BIGINT), (Object)((Object)conversionResultPrimitive.getOutputType()));
        Assert.assertEquals((long)1000L, (long)conversionResultPrimitive.getLong());
    }
}

