/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironments;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlFnExecutorTestBase;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math.BeamSqlAbsExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math.BeamSqlAcosExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math.BeamSqlAsinExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math.BeamSqlAtanExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math.BeamSqlCeilExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math.BeamSqlCosExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math.BeamSqlCotExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math.BeamSqlDegreesExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math.BeamSqlExpExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math.BeamSqlFloorExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math.BeamSqlLnExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math.BeamSqlLogExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math.BeamSqlPiExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math.BeamSqlRadiansExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math.BeamSqlSignExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math.BeamSqlSinExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math.BeamSqlTanExpression;
import org.junit.Assert;
import org.junit.Test;

public class BeamSqlMathUnaryExpressionTest
extends BeamSqlFnExecutorTestBase {
    @Test
    public void testForGreaterThanOneOperands() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)2));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)4));
        Assert.assertFalse((boolean)new BeamSqlAbsExpression(operands).accept());
    }

    @Test
    public void testForOperandsType() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"2"));
        Assert.assertFalse((boolean)new BeamSqlAbsExpression(operands).accept());
    }

    @Test
    public void testForUnaryExpressions() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.SMALLINT, (Object)Short.valueOf("2")));
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)-28965734597L));
        Assert.assertEquals((Object)28965734597L, (Object)new BeamSqlAbsExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testForLnExpression() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.SMALLINT, (Object)Short.valueOf("2")));
        Assert.assertEquals((Object)Math.log(2.0), (Object)new BeamSqlLnExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)2.4));
        Assert.assertEquals((Object)Math.log(2.4), (Object)new BeamSqlLnExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DECIMAL, (Object)BigDecimal.valueOf(2.56)));
        Assert.assertEquals((Object)Math.log(2.56), (Object)new BeamSqlLnExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testForLog10Expression() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.SMALLINT, (Object)Short.valueOf("2")));
        Assert.assertEquals((Object)Math.log10(2.0), (Object)new BeamSqlLogExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)2.4));
        Assert.assertEquals((Object)Math.log10(2.4), (Object)new BeamSqlLogExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DECIMAL, (Object)BigDecimal.valueOf(2.56)));
        Assert.assertEquals((Object)Math.log10(2.56), (Object)new BeamSqlLogExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testForExpExpression() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.SMALLINT, (Object)Short.valueOf("2")));
        Assert.assertEquals((Object)Math.exp(2.0), (Object)new BeamSqlExpExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)2.4));
        Assert.assertEquals((Object)Math.exp(2.4), (Object)new BeamSqlExpExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DECIMAL, (Object)BigDecimal.valueOf(2.56)));
        Assert.assertEquals((Object)Math.exp(2.56), (Object)new BeamSqlExpExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testForAcosExpression() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.SMALLINT, (Object)Short.valueOf("2")));
        Assert.assertEquals((Object)Double.NaN, (Object)new BeamSqlAcosExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)0.45));
        Assert.assertEquals((Object)Math.acos(0.45), (Object)new BeamSqlAcosExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DECIMAL, (Object)BigDecimal.valueOf(-0.367)));
        Assert.assertEquals((Object)Math.acos(-0.367), (Object)new BeamSqlAcosExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testForAsinExpression() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)0.45));
        Assert.assertEquals((Object)Math.asin(0.45), (Object)new BeamSqlAsinExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DECIMAL, (Object)BigDecimal.valueOf(-0.367)));
        Assert.assertEquals((Object)Math.asin(-0.367), (Object)new BeamSqlAsinExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testForAtanExpression() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)0.45));
        Assert.assertEquals((Object)Math.atan(0.45), (Object)new BeamSqlAtanExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DECIMAL, (Object)BigDecimal.valueOf(-0.367)));
        Assert.assertEquals((Object)Math.atan(-0.367), (Object)new BeamSqlAtanExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testForCosExpression() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)0.45));
        Assert.assertEquals((Object)Math.cos(0.45), (Object)new BeamSqlCosExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DECIMAL, (Object)BigDecimal.valueOf(-0.367)));
        Assert.assertEquals((Object)Math.cos(-0.367), (Object)new BeamSqlCosExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testForCotExpression() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)0.45));
        Assert.assertEquals((Object)(1.0 / Math.tan(0.45)), (Object)new BeamSqlCotExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DECIMAL, (Object)BigDecimal.valueOf(-0.367)));
        Assert.assertEquals((Object)(1.0 / Math.tan(-0.367)), (Object)new BeamSqlCotExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testForDegreesExpression() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.SMALLINT, (Object)Short.valueOf("2")));
        Assert.assertEquals((Object)Math.toDegrees(2.0), (Object)new BeamSqlDegreesExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)2.4));
        Assert.assertEquals((Object)Math.toDegrees(2.4), (Object)new BeamSqlDegreesExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DECIMAL, (Object)BigDecimal.valueOf(2.56)));
        Assert.assertEquals((Object)Math.toDegrees(2.56), (Object)new BeamSqlDegreesExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testForRadiansExpression() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.SMALLINT, (Object)Short.valueOf("2")));
        Assert.assertEquals((Object)Math.toRadians(2.0), (Object)new BeamSqlRadiansExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)2.4));
        Assert.assertEquals((Object)Math.toRadians(2.4), (Object)new BeamSqlRadiansExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DECIMAL, (Object)BigDecimal.valueOf(2.56)));
        Assert.assertEquals((Object)Math.toRadians(2.56), (Object)new BeamSqlRadiansExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testForSinExpression() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.SMALLINT, (Object)Short.valueOf("2")));
        Assert.assertEquals((Object)Math.sin(2.0), (Object)new BeamSqlSinExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)2.4));
        Assert.assertEquals((Object)Math.sin(2.4), (Object)new BeamSqlSinExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DECIMAL, (Object)BigDecimal.valueOf(2.56)));
        Assert.assertEquals((Object)Math.sin(2.56), (Object)new BeamSqlSinExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testForTanExpression() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.SMALLINT, (Object)Short.valueOf("2")));
        Assert.assertEquals((Object)Math.tan(2.0), (Object)new BeamSqlTanExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)2.4));
        Assert.assertEquals((Object)Math.tan(2.4), (Object)new BeamSqlTanExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DECIMAL, (Object)BigDecimal.valueOf(2.56)));
        Assert.assertEquals((Object)Math.tan(2.56), (Object)new BeamSqlTanExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testForSignExpression() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.SMALLINT, (Object)Short.valueOf("2")));
        Assert.assertEquals((Object)1, (Object)new BeamSqlSignExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)2.4));
        Assert.assertEquals((Object)1.0, (Object)new BeamSqlSignExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DECIMAL, (Object)BigDecimal.valueOf(2.56)));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new BeamSqlSignExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testForPi() {
        Assert.assertEquals((Object)Math.PI, (Object)new BeamSqlPiExpression().evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testForCeil() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)2.68687979));
        Assert.assertEquals((Object)Math.ceil(2.68687979), (Object)new BeamSqlCeilExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testForFloor() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)2.68687979));
        Assert.assertEquals((Object)Math.floor(2.68687979), (Object)new BeamSqlFloorExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }
}

