/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math;

import java.util.ArrayList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.runtime.SqlFunctions;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironments;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlFnExecutorTestBase;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlInputRefExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math.BeamSqlAtan2Expression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math.BeamSqlPowerExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math.BeamSqlRoundExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math.BeamSqlTruncateExpression;
import org.junit.Assert;
import org.junit.Test;

public class BeamSqlMathBinaryExpressionTest
extends BeamSqlFnExecutorTestBase {
    @Test
    public void testForGreaterThanTwoOperands() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)2));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)4));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)5));
        Assert.assertFalse((boolean)new BeamSqlRoundExpression(operands).accept());
    }

    @Test
    public void testForOneOperand() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)2));
    }

    @Test
    public void testForOperandsType() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"2"));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)4));
        Assert.assertFalse((boolean)new BeamSqlRoundExpression(operands).accept());
    }

    @Test
    public void testRoundFunction() {
        ArrayList<Object> operands = new ArrayList<Object>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)2.0));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)4.0));
        Assert.assertEquals((Object)2.0, (Object)new BeamSqlRoundExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)2));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)2));
        Assert.assertEquals((Object)2, (Object)new BeamSqlRoundExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)5L));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)3L));
        Assert.assertEquals((Object)5L, (Object)new BeamSqlRoundExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.SMALLINT, (Object)Short.valueOf("4")));
        Assert.assertEquals((Object)SqlFunctions.toShort(4), (Object)new BeamSqlRoundExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)2L));
        Assert.assertEquals((Object)2L, (Object)new BeamSqlRoundExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)1.1));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1L));
        Assert.assertEquals((Object)1.1, (Object)new BeamSqlRoundExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)2.368768));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)2));
        Assert.assertEquals((Object)2.37, (Object)new BeamSqlRoundExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)3.78683686458));
        Assert.assertEquals((Object)4.0, (Object)new BeamSqlRoundExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)378.683686458));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)-2));
        Assert.assertEquals((Object)400.0, (Object)new BeamSqlRoundExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)378.683686458));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)-1));
        Assert.assertEquals((Object)380.0, (Object)new BeamSqlRoundExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)2));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)2.2));
        Assert.assertEquals((Object)2, (Object)new BeamSqlRoundExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        BeamSqlInputRefExpression ref0 = new BeamSqlInputRefExpression(SqlTypeName.BIGINT, 0);
        operands.add(ref0);
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)2L));
        Assert.assertEquals((Object)1234567L, (Object)new BeamSqlRoundExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testPowerFunction() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)2.0));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)4.0));
        Assert.assertEquals((Object)16.0, (Object)new BeamSqlPowerExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)2));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)2));
        Assert.assertEquals((Object)4.0, (Object)new BeamSqlPowerExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)2));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)3L));
        Assert.assertEquals((Object)8.0, (Object)new BeamSqlPowerExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)2L));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)2L));
        Assert.assertEquals((Object)4.0, (Object)new BeamSqlPowerExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)1.1));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)1));
        Assert.assertEquals((Object)1.1, (Object)new BeamSqlPowerExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)1.1));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)1L));
        Assert.assertEquals((Object)1.1, (Object)new BeamSqlPowerExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)2));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)2.2));
        Assert.assertEquals((Object)Math.pow(2.0, 2.2), (Object)new BeamSqlPowerExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testForTruncate() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)2.0));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)4.0));
        Assert.assertEquals((Object)2.0, (Object)new BeamSqlTruncateExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)2.80685));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)4));
        Assert.assertEquals((Object)2.8068, (Object)new BeamSqlTruncateExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testForAtan2() {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)0.875));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)0.56));
        Assert.assertEquals((Object)Math.atan2(0.875, 0.56), (Object)new BeamSqlAtan2Expression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }
}

