/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date;

import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util.TimeUnit;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.TimeUnitUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TimeUnitUtilsTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testReturnsInternalTimeUnitMultipliers() {
        Assert.assertEquals((Object)TimeUnit.SECOND.multiplier, (Object)TimeUnitUtils.timeUnitInternalMultiplier((SqlTypeName)SqlTypeName.INTERVAL_SECOND));
        Assert.assertEquals((Object)TimeUnit.MINUTE.multiplier, (Object)TimeUnitUtils.timeUnitInternalMultiplier((SqlTypeName)SqlTypeName.INTERVAL_MINUTE));
        Assert.assertEquals((Object)TimeUnit.HOUR.multiplier, (Object)TimeUnitUtils.timeUnitInternalMultiplier((SqlTypeName)SqlTypeName.INTERVAL_HOUR));
        Assert.assertEquals((Object)TimeUnit.DAY.multiplier, (Object)TimeUnitUtils.timeUnitInternalMultiplier((SqlTypeName)SqlTypeName.INTERVAL_DAY));
        Assert.assertEquals((Object)TimeUnit.MONTH.multiplier, (Object)TimeUnitUtils.timeUnitInternalMultiplier((SqlTypeName)SqlTypeName.INTERVAL_MONTH));
        Assert.assertEquals((Object)TimeUnit.YEAR.multiplier, (Object)TimeUnitUtils.timeUnitInternalMultiplier((SqlTypeName)SqlTypeName.INTERVAL_YEAR));
    }

    @Test
    public void testThrowsForUnsupportedIntervalType() {
        this.thrown.expect(IllegalArgumentException.class);
        TimeUnitUtils.timeUnitInternalMultiplier((SqlTypeName)SqlTypeName.INTERVAL_DAY_MINUTE);
    }
}

