/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date;

import java.util.Arrays;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util.TimeUnit;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironments;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlTimestampMinusTimestampExpression;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BeamSqlTimestampMinusTimestampExpressionTest {
    private static final Row NULL_ROW = null;
    private static final BoundedWindow NULL_WINDOW = null;
    private static final DateTime DATE = new DateTime().withDate(2017, 3, 4).withTime(3, 2, 1, 0);
    private static final DateTime DATE_MINUS_2_SEC = DATE.minusSeconds(2);
    private static final DateTime DATE_MINUS_3_MIN = DATE.minusMinutes(3);
    private static final DateTime DATE_MINUS_4_HOURS = DATE.minusHours(4);
    private static final DateTime DATE_MINUS_7_DAYS = DATE.minusDays(7);
    private static final DateTime DATE_MINUS_2_MONTHS = DATE.minusMonths(2);
    private static final DateTime DATE_MINUS_1_YEAR = DATE.minusYears(1);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testOutputTypeIsBigint() {
        BeamSqlTimestampMinusTimestampExpression minusExpression = BeamSqlTimestampMinusTimestampExpressionTest.minusExpression(SqlTypeName.INTERVAL_DAY, this.timestamp(DATE_MINUS_2_SEC), this.timestamp(DATE));
        Assert.assertEquals((Object)((Object)SqlTypeName.BIGINT), (Object)((Object)minusExpression.getOutputType()));
    }

    @Test
    public void testAccepts2Timestamps() {
        BeamSqlTimestampMinusTimestampExpression minusExpression = BeamSqlTimestampMinusTimestampExpressionTest.minusExpression(SqlTypeName.INTERVAL_DAY, this.timestamp(DATE_MINUS_2_SEC), this.timestamp(DATE));
        Assert.assertTrue((boolean)minusExpression.accept());
    }

    @Test
    public void testDoesNotAccept3Timestamps() {
        BeamSqlTimestampMinusTimestampExpression minusExpression = BeamSqlTimestampMinusTimestampExpressionTest.minusExpression(SqlTypeName.INTERVAL_DAY, this.timestamp(DATE_MINUS_2_SEC), this.timestamp(DATE_MINUS_1_YEAR), this.timestamp(DATE));
        Assert.assertFalse((boolean)minusExpression.accept());
    }

    @Test
    public void testDoesNotAccept1Timestamp() {
        BeamSqlTimestampMinusTimestampExpression minusExpression = BeamSqlTimestampMinusTimestampExpressionTest.minusExpression(SqlTypeName.INTERVAL_DAY, this.timestamp(DATE));
        Assert.assertFalse((boolean)minusExpression.accept());
    }

    @Test
    public void testDoesNotAcceptUnsupportedIntervalToCount() {
        BeamSqlTimestampMinusTimestampExpression minusExpression = BeamSqlTimestampMinusTimestampExpressionTest.minusExpression(SqlTypeName.INTERVAL_DAY_MINUTE, this.timestamp(DATE_MINUS_2_SEC), this.timestamp(DATE));
        Assert.assertFalse((boolean)minusExpression.accept());
    }

    @Test
    public void testDoesNotAcceptNotTimestampAsOperandOne() {
        BeamSqlTimestampMinusTimestampExpression minusExpression = BeamSqlTimestampMinusTimestampExpressionTest.minusExpression(SqlTypeName.INTERVAL_DAY, new BeamSqlExpression[]{BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)3), this.timestamp(DATE)});
        Assert.assertFalse((boolean)minusExpression.accept());
    }

    @Test
    public void testDoesNotAcceptNotTimestampAsOperandTwo() {
        BeamSqlTimestampMinusTimestampExpression minusExpression = BeamSqlTimestampMinusTimestampExpressionTest.minusExpression(SqlTypeName.INTERVAL_DAY, new BeamSqlExpression[]{this.timestamp(DATE), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)3)});
        Assert.assertFalse((boolean)minusExpression.accept());
    }

    @Test
    public void testEvaluateDiffSeconds() {
        BeamSqlTimestampMinusTimestampExpression minusExpression = BeamSqlTimestampMinusTimestampExpressionTest.minusExpression(SqlTypeName.INTERVAL_SECOND, this.timestamp(DATE), this.timestamp(DATE_MINUS_2_SEC));
        long expectedResult = this.applyMultiplier(2L, TimeUnit.SECOND);
        Assert.assertEquals((long)expectedResult, (long)this.eval(minusExpression));
    }

    @Test
    public void testEvaluateDiffMinutes() {
        BeamSqlTimestampMinusTimestampExpression minusExpression = BeamSqlTimestampMinusTimestampExpressionTest.minusExpression(SqlTypeName.INTERVAL_MINUTE, this.timestamp(DATE), this.timestamp(DATE_MINUS_3_MIN));
        long expectedResult = this.applyMultiplier(3L, TimeUnit.MINUTE);
        Assert.assertEquals((long)expectedResult, (long)this.eval(minusExpression));
    }

    @Test
    public void testEvaluateDiffHours() {
        BeamSqlTimestampMinusTimestampExpression minusExpression = BeamSqlTimestampMinusTimestampExpressionTest.minusExpression(SqlTypeName.INTERVAL_HOUR, this.timestamp(DATE), this.timestamp(DATE_MINUS_4_HOURS));
        long expectedResult = this.applyMultiplier(4L, TimeUnit.HOUR);
        Assert.assertEquals((long)expectedResult, (long)this.eval(minusExpression));
    }

    @Test
    public void testEvaluateDiffDays() {
        BeamSqlTimestampMinusTimestampExpression minusExpression = BeamSqlTimestampMinusTimestampExpressionTest.minusExpression(SqlTypeName.INTERVAL_DAY, this.timestamp(DATE), this.timestamp(DATE_MINUS_7_DAYS));
        long expectedResult = this.applyMultiplier(7L, TimeUnit.DAY);
        Assert.assertEquals((long)expectedResult, (long)this.eval(minusExpression));
    }

    @Test
    public void testEvaluateDiffMonths() {
        BeamSqlTimestampMinusTimestampExpression minusExpression = BeamSqlTimestampMinusTimestampExpressionTest.minusExpression(SqlTypeName.INTERVAL_MONTH, this.timestamp(DATE), this.timestamp(DATE_MINUS_2_MONTHS));
        long expectedResult = this.applyMultiplier(2L, TimeUnit.MONTH);
        Assert.assertEquals((long)expectedResult, (long)this.eval(minusExpression));
    }

    @Test
    public void testEvaluateDiffYears() {
        BeamSqlTimestampMinusTimestampExpression minusExpression = BeamSqlTimestampMinusTimestampExpressionTest.minusExpression(SqlTypeName.INTERVAL_YEAR, this.timestamp(DATE), this.timestamp(DATE_MINUS_1_YEAR));
        long expectedResult = this.applyMultiplier(1L, TimeUnit.YEAR);
        Assert.assertEquals((long)expectedResult, (long)this.eval(minusExpression));
    }

    @Test
    public void testEvaluateNegativeDiffSeconds() {
        BeamSqlTimestampMinusTimestampExpression minusExpression = BeamSqlTimestampMinusTimestampExpressionTest.minusExpression(SqlTypeName.INTERVAL_SECOND, this.timestamp(DATE_MINUS_2_SEC), this.timestamp(DATE));
        long expectedResult = this.applyMultiplier(-2L, TimeUnit.SECOND);
        Assert.assertEquals((long)expectedResult, (long)this.eval(minusExpression));
    }

    @Test
    public void testEvaluateThrowsForUnsupportedIntervalType() {
        this.thrown.expect(IllegalArgumentException.class);
        BeamSqlTimestampMinusTimestampExpression minusExpression = BeamSqlTimestampMinusTimestampExpressionTest.minusExpression(SqlTypeName.INTERVAL_DAY_MINUTE, this.timestamp(DATE_MINUS_2_SEC), this.timestamp(DATE));
        this.eval(minusExpression);
    }

    private static BeamSqlTimestampMinusTimestampExpression minusExpression(SqlTypeName intervalsToCount, BeamSqlExpression ... operands) {
        return new BeamSqlTimestampMinusTimestampExpression(Arrays.asList(operands), intervalsToCount);
    }

    private BeamSqlExpression timestamp(DateTime date) {
        return BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.TIMESTAMP, (Object)date);
    }

    private long eval(BeamSqlTimestampMinusTimestampExpression minusExpression) {
        return minusExpression.evaluate(NULL_ROW, NULL_WINDOW, BeamSqlExpressionEnvironments.empty()).getLong();
    }

    private long applyMultiplier(long value, TimeUnit timeUnit) {
        return value * timeUnit.multiplier.longValue();
    }
}

