/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date;

import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironments;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlIntervalMultiplyExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.TimeUnitUtils;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.junit.Assert;
import org.junit.Test;

public class BeamSqlIntervalMultiplyExpressionTest {
    private static final Row NULL_INPUT_ROW = null;
    private static final BoundedWindow NULL_WINDOW = null;
    private static final BigDecimal DECIMAL_THREE = new BigDecimal(3);
    private static final BigDecimal DECIMAL_FOUR = new BigDecimal(4);
    private static final BeamSqlExpression SQL_INTERVAL_DAY = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTERVAL_DAY, (Object)DECIMAL_THREE);
    private static final BeamSqlExpression SQL_INTERVAL_MONTH = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTERVAL_MONTH, (Object)DECIMAL_FOUR);
    private static final BeamSqlExpression SQL_INTEGER_FOUR = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)4);
    private static final BeamSqlExpression SQL_INTEGER_FIVE = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)5);

    @Test
    public void testHappyPath_outputTypeAndAccept() {
        BeamSqlIntervalMultiplyExpression multiplyExpression = this.newMultiplyExpression(SQL_INTERVAL_DAY, SQL_INTEGER_FOUR);
        Assert.assertEquals((Object)((Object)SqlTypeName.INTERVAL_DAY), (Object)((Object)multiplyExpression.getOutputType()));
        Assert.assertTrue((boolean)multiplyExpression.accept());
    }

    @Test
    public void testDoesNotAcceptTreeOperands() {
        BeamSqlIntervalMultiplyExpression multiplyExpression = this.newMultiplyExpression(SQL_INTERVAL_DAY, SQL_INTEGER_FIVE, SQL_INTEGER_FOUR);
        Assert.assertEquals((Object)((Object)SqlTypeName.INTERVAL_DAY), (Object)((Object)multiplyExpression.getOutputType()));
        Assert.assertFalse((boolean)multiplyExpression.accept());
    }

    @Test
    public void testDoesNotAcceptWithoutIntervalOperand() {
        BeamSqlIntervalMultiplyExpression multiplyExpression = this.newMultiplyExpression(SQL_INTEGER_FOUR, SQL_INTEGER_FIVE);
        Assert.assertNull((Object)((Object)multiplyExpression.getOutputType()));
        Assert.assertFalse((boolean)multiplyExpression.accept());
    }

    @Test
    public void testDoesNotAcceptWithoutIntegerOperand() {
        BeamSqlIntervalMultiplyExpression multiplyExpression = this.newMultiplyExpression(SQL_INTERVAL_DAY, SQL_INTERVAL_MONTH);
        Assert.assertEquals((Object)((Object)SqlTypeName.INTERVAL_DAY), (Object)((Object)multiplyExpression.getOutputType()));
        Assert.assertFalse((boolean)multiplyExpression.accept());
    }

    @Test
    public void testEvaluate_integerOperand() {
        BeamSqlIntervalMultiplyExpression multiplyExpression = this.newMultiplyExpression(SQL_INTERVAL_DAY, SQL_INTEGER_FOUR);
        BeamSqlPrimitive multiplicationResult = multiplyExpression.evaluate(NULL_INPUT_ROW, NULL_WINDOW, BeamSqlExpressionEnvironments.empty());
        BigDecimal expectedResult = DECIMAL_FOUR.multiply(TimeUnitUtils.timeUnitInternalMultiplier((SqlTypeName)SqlTypeName.INTERVAL_DAY));
        Assert.assertEquals((Object)expectedResult, (Object)multiplicationResult.getDecimal());
        Assert.assertEquals((Object)((Object)SqlTypeName.INTERVAL_DAY), (Object)((Object)multiplicationResult.getOutputType()));
    }

    private BeamSqlIntervalMultiplyExpression newMultiplyExpression(BeamSqlExpression ... operands) {
        return new BeamSqlIntervalMultiplyExpression(Arrays.asList(operands));
    }
}

