/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date;

import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util.TimeUnit;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironments;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlDateExpressionTestBase;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlDatetimePlusExpression;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BeamSqlDatetimePlusExpressionTest
extends BeamSqlDateExpressionTestBase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final Row NULL_INPUT_ROW = null;
    private static final BoundedWindow NULL_WINDOW = null;
    private static final DateTime DATETIME = BeamSqlDatetimePlusExpressionTest.str2DateTime("1984-04-19 01:02:03");
    private static final DateTime DATE = BeamSqlDatetimePlusExpressionTest.str2Date("2018-07-01");
    private static final DateTime DATETIME_PLUS_15_SECONDS = DATETIME.plusSeconds(15);
    private static final DateTime DATETIME_PLUS_10_MINUTES = DATETIME.plusMinutes(10);
    private static final DateTime DATETIME_PLUS_7_HOURS = DATETIME.plusHours(7);
    private static final DateTime DATETIME_PLUS_3_DAYS = DATETIME.plusDays(3);
    private static final DateTime DATETIME_PLUS_2_MONTHS = DATETIME.plusMonths(2);
    private static final DateTime DATETIME_PLUS_11_YEARS = DATETIME.plusYears(11);
    private static final DateTime DATE_PLUS_15_SECONDS = DATE.plusSeconds(15);
    private static final DateTime DATE_PLUS_10_MINUTES = DATE.plusMinutes(10);
    private static final DateTime DATE_PLUS_7_HOURS = DATE.plusHours(7);
    private static final DateTime DATE_PLUS_3_DAYS = DATE.plusDays(3);
    private static final DateTime DATE_PLUS_2_MONTHS = DATE.plusMonths(2);
    private static final DateTime DATE_PLUS_11_YEARS = DATE.plusYears(11);
    private static final BeamSqlExpression SQL_INTERVAL_15_SECONDS = BeamSqlDatetimePlusExpressionTest.interval(SqlTypeName.INTERVAL_SECOND, 15);
    private static final BeamSqlExpression SQL_INTERVAL_10_MINUTES = BeamSqlDatetimePlusExpressionTest.interval(SqlTypeName.INTERVAL_MINUTE, 10);
    private static final BeamSqlExpression SQL_INTERVAL_7_HOURS = BeamSqlDatetimePlusExpressionTest.interval(SqlTypeName.INTERVAL_HOUR, 7);
    private static final BeamSqlExpression SQL_INTERVAL_3_DAYS = BeamSqlDatetimePlusExpressionTest.interval(SqlTypeName.INTERVAL_DAY, 3);
    private static final BeamSqlExpression SQL_INTERVAL_2_MONTHS = BeamSqlDatetimePlusExpressionTest.interval(SqlTypeName.INTERVAL_MONTH, 2);
    private static final BeamSqlExpression SQL_INTERVAL_4_MONTHS = BeamSqlDatetimePlusExpressionTest.interval(SqlTypeName.INTERVAL_MONTH, 4);
    private static final BeamSqlExpression SQL_INTERVAL_11_YEARS = BeamSqlDatetimePlusExpressionTest.interval(SqlTypeName.INTERVAL_YEAR, 11);
    private static final BeamSqlExpression SQL_TIMESTAMP = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.TIMESTAMP, (Object)DATETIME);
    private static final BeamSqlExpression SQL_DATE = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DATE, (Object)DATE);

    @Test
    public void testHappyPath_outputTypeAndAccept() {
        BeamSqlDatetimePlusExpression plusExpression = BeamSqlDatetimePlusExpressionTest.dateTimePlus(SQL_TIMESTAMP, SQL_INTERVAL_3_DAYS);
        Assert.assertEquals((Object)((Object)SqlTypeName.TIMESTAMP), (Object)((Object)plusExpression.getOutputType()));
        Assert.assertTrue((boolean)plusExpression.accept());
    }

    @Test
    public void testDateAndInterval_outputTypeAndAccept() {
        BeamSqlDatetimePlusExpression plusExpression = BeamSqlDatetimePlusExpressionTest.dateTimePlus(SQL_DATE, SQL_INTERVAL_3_DAYS);
        Assert.assertEquals((Object)((Object)SqlTypeName.TIMESTAMP), (Object)((Object)plusExpression.getOutputType()));
        Assert.assertTrue((boolean)plusExpression.accept());
    }

    @Test
    public void testDoesNotAcceptTreeOperands() {
        BeamSqlDatetimePlusExpression plusExpression = BeamSqlDatetimePlusExpressionTest.dateTimePlus(SQL_TIMESTAMP, SQL_INTERVAL_3_DAYS, SQL_INTERVAL_4_MONTHS);
        Assert.assertEquals((Object)((Object)SqlTypeName.TIMESTAMP), (Object)((Object)plusExpression.getOutputType()));
        Assert.assertFalse((boolean)plusExpression.accept());
    }

    @Test
    public void testDoesNotAcceptWithoutTimestampOperand() {
        BeamSqlDatetimePlusExpression plusExpression = BeamSqlDatetimePlusExpressionTest.dateTimePlus(SQL_INTERVAL_3_DAYS, SQL_INTERVAL_4_MONTHS);
        Assert.assertEquals((Object)((Object)SqlTypeName.TIMESTAMP), (Object)((Object)plusExpression.getOutputType()));
        Assert.assertFalse((boolean)plusExpression.accept());
    }

    @Test
    public void testDoesNotAcceptWithoutIntervalOperand() {
        BeamSqlDatetimePlusExpression plusExpression = BeamSqlDatetimePlusExpressionTest.dateTimePlus(SQL_TIMESTAMP, SQL_TIMESTAMP);
        Assert.assertEquals((Object)((Object)SqlTypeName.TIMESTAMP), (Object)((Object)plusExpression.getOutputType()));
        Assert.assertFalse((boolean)plusExpression.accept());
    }

    @Test
    public void testEvaluate() {
        Assert.assertEquals((Object)DATETIME_PLUS_15_SECONDS, (Object)BeamSqlDatetimePlusExpressionTest.evalDatetimePlus(SQL_TIMESTAMP, SQL_INTERVAL_15_SECONDS));
        Assert.assertEquals((Object)DATETIME_PLUS_10_MINUTES, (Object)BeamSqlDatetimePlusExpressionTest.evalDatetimePlus(SQL_TIMESTAMP, SQL_INTERVAL_10_MINUTES));
        Assert.assertEquals((Object)DATETIME_PLUS_7_HOURS, (Object)BeamSqlDatetimePlusExpressionTest.evalDatetimePlus(SQL_TIMESTAMP, SQL_INTERVAL_7_HOURS));
        Assert.assertEquals((Object)DATETIME_PLUS_3_DAYS, (Object)BeamSqlDatetimePlusExpressionTest.evalDatetimePlus(SQL_TIMESTAMP, SQL_INTERVAL_3_DAYS));
        Assert.assertEquals((Object)DATETIME_PLUS_2_MONTHS, (Object)BeamSqlDatetimePlusExpressionTest.evalDatetimePlus(SQL_TIMESTAMP, SQL_INTERVAL_2_MONTHS));
        Assert.assertEquals((Object)DATETIME_PLUS_11_YEARS, (Object)BeamSqlDatetimePlusExpressionTest.evalDatetimePlus(SQL_TIMESTAMP, SQL_INTERVAL_11_YEARS));
        Assert.assertEquals((Object)DATE_PLUS_15_SECONDS, (Object)BeamSqlDatetimePlusExpressionTest.evalDatetimePlus(SQL_DATE, SQL_INTERVAL_15_SECONDS));
        Assert.assertEquals((Object)DATE_PLUS_10_MINUTES, (Object)BeamSqlDatetimePlusExpressionTest.evalDatetimePlus(SQL_DATE, SQL_INTERVAL_10_MINUTES));
        Assert.assertEquals((Object)DATE_PLUS_7_HOURS, (Object)BeamSqlDatetimePlusExpressionTest.evalDatetimePlus(SQL_DATE, SQL_INTERVAL_7_HOURS));
        Assert.assertEquals((Object)DATE_PLUS_3_DAYS, (Object)BeamSqlDatetimePlusExpressionTest.evalDatetimePlus(SQL_DATE, SQL_INTERVAL_3_DAYS));
        Assert.assertEquals((Object)DATE_PLUS_2_MONTHS, (Object)BeamSqlDatetimePlusExpressionTest.evalDatetimePlus(SQL_DATE, SQL_INTERVAL_2_MONTHS));
        Assert.assertEquals((Object)DATE_PLUS_11_YEARS, (Object)BeamSqlDatetimePlusExpressionTest.evalDatetimePlus(SQL_DATE, SQL_INTERVAL_11_YEARS));
    }

    @Test
    public void testEvaluateThrowsForUnsupportedIntervalType() {
        this.thrown.expect(UnsupportedOperationException.class);
        BeamSqlPrimitive unsupportedInterval = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTERVAL_YEAR_MONTH, (Object)3);
        BeamSqlDatetimePlusExpressionTest.evalDatetimePlus(SQL_TIMESTAMP, (BeamSqlExpression)unsupportedInterval);
    }

    private static ReadableInstant evalDatetimePlus(BeamSqlExpression date, BeamSqlExpression interval) {
        return BeamSqlDatetimePlusExpressionTest.dateTimePlus(date, interval).evaluate(NULL_INPUT_ROW, NULL_WINDOW, BeamSqlExpressionEnvironments.empty()).getDate();
    }

    private static BeamSqlDatetimePlusExpression dateTimePlus(BeamSqlExpression ... operands) {
        return new BeamSqlDatetimePlusExpression(Arrays.asList(operands));
    }

    private static BeamSqlExpression interval(SqlTypeName type, int multiplier) {
        return BeamSqlPrimitive.of((SqlTypeName)type, (Object)BeamSqlDatetimePlusExpressionTest.timeUnitInternalMultiplier(type).multiply(new BigDecimal(multiplier)));
    }

    private static BigDecimal timeUnitInternalMultiplier(SqlTypeName sqlIntervalType) {
        switch (sqlIntervalType) {
            case INTERVAL_SECOND: {
                return TimeUnit.SECOND.multiplier;
            }
            case INTERVAL_MINUTE: {
                return TimeUnit.MINUTE.multiplier;
            }
            case INTERVAL_HOUR: {
                return TimeUnit.HOUR.multiplier;
            }
            case INTERVAL_DAY: {
                return TimeUnit.DAY.multiplier;
            }
            case INTERVAL_MONTH: {
                return TimeUnit.MONTH.multiplier;
            }
            case INTERVAL_YEAR: {
                return TimeUnit.YEAR.multiplier;
            }
        }
        throw new IllegalArgumentException("Interval " + (Object)((Object)sqlIntervalType) + " cannot be converted to TimeUnit");
    }
}

