/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util.TimeUnit;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironments;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlDatetimeMinusIntervalExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.TimeUnitUtils;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class BeamSqlDatetimeMinusIntervalExpressionTest {
    private static final Row NULL_ROW = null;
    private static final BoundedWindow NULL_WINDOW = null;
    private static final DateTime DATE = new DateTime(329281L);
    private static final DateTime DATE_MINUS_2_SEC = DATE.minusSeconds(2);
    private static final BeamSqlPrimitive DATETIME = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DATE, (Object)DATE);
    private static final BeamSqlPrimitive INTERVAL_2_SEC = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTERVAL_SECOND, (Object)TimeUnit.SECOND.multiplier.multiply(new BigDecimal(2)));
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testAcceptsHappyPath() {
        BeamSqlDatetimeMinusIntervalExpression minusExpression = BeamSqlDatetimeMinusIntervalExpressionTest.minusExpression(SqlTypeName.TIMESTAMP, new BeamSqlExpression[]{DATETIME, INTERVAL_2_SEC});
        Assert.assertTrue((boolean)minusExpression.accept());
    }

    @Test
    public void testDoesNotAcceptWrongOutputType() {
        HashSet<SqlTypeName> unsupportedTypes = new HashSet<SqlTypeName>(SqlTypeName.ALL_TYPES);
        unsupportedTypes.remove((Object)SqlTypeName.TIMESTAMP);
        for (SqlTypeName unsupportedType : unsupportedTypes) {
            BeamSqlDatetimeMinusIntervalExpression minusExpression = BeamSqlDatetimeMinusIntervalExpressionTest.minusExpression(unsupportedType, new BeamSqlExpression[]{DATETIME, INTERVAL_2_SEC});
            Assert.assertFalse((boolean)minusExpression.accept());
        }
    }

    @Test
    public void testDoesNotAcceptWrongFirstOperand() {
        HashSet<SqlTypeName> unsupportedTypes = new HashSet<SqlTypeName>(SqlTypeName.ALL_TYPES);
        unsupportedTypes.removeAll(SqlTypeName.DATETIME_TYPES);
        for (SqlTypeName unsupportedType : unsupportedTypes) {
            BeamSqlPrimitive unsupportedOperand = (BeamSqlPrimitive)Mockito.mock(BeamSqlPrimitive.class);
            ((BeamSqlPrimitive)Mockito.doReturn((Object)((Object)unsupportedType)).when((Object)unsupportedOperand)).getOutputType();
            BeamSqlDatetimeMinusIntervalExpression minusExpression = BeamSqlDatetimeMinusIntervalExpressionTest.minusExpression(SqlTypeName.TIMESTAMP, new BeamSqlExpression[]{unsupportedOperand, INTERVAL_2_SEC});
            Assert.assertFalse((boolean)minusExpression.accept());
        }
    }

    @Test
    public void testDoesNotAcceptWrongSecondOperand() {
        HashSet<SqlTypeName> unsupportedTypes = new HashSet<SqlTypeName>(SqlTypeName.ALL_TYPES);
        unsupportedTypes.removeAll(TimeUnitUtils.INTERVALS_DURATIONS_TYPES.keySet());
        for (SqlTypeName unsupportedType : unsupportedTypes) {
            BeamSqlPrimitive unsupportedOperand = (BeamSqlPrimitive)Mockito.mock(BeamSqlPrimitive.class);
            ((BeamSqlPrimitive)Mockito.doReturn((Object)((Object)unsupportedType)).when((Object)unsupportedOperand)).getOutputType();
            BeamSqlDatetimeMinusIntervalExpression minusExpression = BeamSqlDatetimeMinusIntervalExpressionTest.minusExpression(SqlTypeName.TIMESTAMP, new BeamSqlExpression[]{DATETIME, unsupportedOperand});
            Assert.assertFalse((boolean)minusExpression.accept());
        }
    }

    @Test
    public void testAcceptsAllSupportedIntervalTypes() {
        for (SqlTypeName unsupportedType : TimeUnitUtils.INTERVALS_DURATIONS_TYPES.keySet()) {
            BeamSqlPrimitive unsupportedOperand = (BeamSqlPrimitive)Mockito.mock(BeamSqlPrimitive.class);
            ((BeamSqlPrimitive)Mockito.doReturn((Object)((Object)unsupportedType)).when((Object)unsupportedOperand)).getOutputType();
            BeamSqlDatetimeMinusIntervalExpression minusExpression = BeamSqlDatetimeMinusIntervalExpressionTest.minusExpression(SqlTypeName.TIMESTAMP, new BeamSqlExpression[]{DATETIME, unsupportedOperand});
            Assert.assertTrue((boolean)minusExpression.accept());
        }
    }

    @Test
    public void testEvaluateHappyPath() {
        BeamSqlDatetimeMinusIntervalExpression minusExpression = BeamSqlDatetimeMinusIntervalExpressionTest.minusExpression(SqlTypeName.TIMESTAMP, new BeamSqlExpression[]{DATETIME, INTERVAL_2_SEC});
        BeamSqlPrimitive subtractionResult = minusExpression.evaluate(NULL_ROW, NULL_WINDOW, BeamSqlExpressionEnvironments.empty());
        Assert.assertEquals((Object)((Object)SqlTypeName.TIMESTAMP), (Object)((Object)subtractionResult.getOutputType()));
        Assert.assertEquals((Object)DATE_MINUS_2_SEC, (Object)subtractionResult.getDate());
    }

    private static BeamSqlDatetimeMinusIntervalExpression minusExpression(SqlTypeName intervalsToCount, BeamSqlExpression ... operands) {
        return new BeamSqlDatetimeMinusIntervalExpression(Arrays.asList(operands), intervalsToCount);
    }
}

