/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date;

import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util.TimeUnit;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironments;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlDatetimeMinusExpression;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class BeamSqlDatetimeMinusExpressionTest {
    private static final Row NULL_ROW = null;
    private static final BoundedWindow NULL_WINDOW = null;
    private static final DateTime DATE = new DateTime(329281L);
    private static final DateTime DATE_MINUS_2_SEC = DATE.minusSeconds(2);
    private static final BeamSqlPrimitive TIMESTAMP = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.TIMESTAMP, (Object)DATE);
    private static final BeamSqlPrimitive DATE1 = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DATE, (Object)DATE);
    private static final BeamSqlPrimitive TIMESTAMP_MINUS_2_SEC = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.TIMESTAMP, (Object)DATE_MINUS_2_SEC);
    private static final BeamSqlPrimitive INTERVAL_2_SEC = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTERVAL_SECOND, (Object)TimeUnit.SECOND.multiplier.multiply(new BigDecimal(2)));
    private static final BeamSqlPrimitive STRING = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"hello");

    @Test
    public void testOutputType() {
        BeamSqlDatetimeMinusExpression minusExpression1 = BeamSqlDatetimeMinusExpressionTest.minusExpression(SqlTypeName.TIMESTAMP, new BeamSqlExpression[]{TIMESTAMP, INTERVAL_2_SEC});
        BeamSqlDatetimeMinusExpression minusExpression2 = BeamSqlDatetimeMinusExpressionTest.minusExpression(SqlTypeName.BIGINT, new BeamSqlExpression[]{TIMESTAMP, TIMESTAMP_MINUS_2_SEC});
        Assert.assertEquals((Object)((Object)SqlTypeName.TIMESTAMP), (Object)((Object)minusExpression1.getOutputType()));
        Assert.assertEquals((Object)((Object)SqlTypeName.BIGINT), (Object)((Object)minusExpression2.getOutputType()));
    }

    @Test
    public void testAcceptsTimestampMinusTimestamp() {
        BeamSqlDatetimeMinusExpression minusExpression = BeamSqlDatetimeMinusExpressionTest.minusExpression(SqlTypeName.INTERVAL_SECOND, new BeamSqlExpression[]{TIMESTAMP, TIMESTAMP_MINUS_2_SEC});
        Assert.assertTrue((boolean)minusExpression.accept());
    }

    @Test
    public void testAcceptsTimestampMinusInteval() {
        BeamSqlDatetimeMinusExpression minusExpression = BeamSqlDatetimeMinusExpressionTest.minusExpression(SqlTypeName.TIMESTAMP, new BeamSqlExpression[]{TIMESTAMP, INTERVAL_2_SEC});
        Assert.assertTrue((boolean)minusExpression.accept());
    }

    @Test
    public void testDoesNotAcceptUnsupportedReturnType() {
        BeamSqlDatetimeMinusExpression minusExpression = BeamSqlDatetimeMinusExpressionTest.minusExpression(SqlTypeName.BIGINT, new BeamSqlExpression[]{TIMESTAMP, INTERVAL_2_SEC});
        Assert.assertFalse((boolean)minusExpression.accept());
    }

    @Test
    public void testDoesNotAcceptUnsupportedFirstOperand() {
        BeamSqlDatetimeMinusExpression minusExpression = BeamSqlDatetimeMinusExpressionTest.minusExpression(SqlTypeName.TIMESTAMP, new BeamSqlExpression[]{STRING, INTERVAL_2_SEC});
        Assert.assertFalse((boolean)minusExpression.accept());
    }

    @Test
    public void testDoesNotAcceptUnsupportedSecondOperand() {
        BeamSqlDatetimeMinusExpression minusExpression = BeamSqlDatetimeMinusExpressionTest.minusExpression(SqlTypeName.TIMESTAMP, new BeamSqlExpression[]{TIMESTAMP, STRING});
        Assert.assertFalse((boolean)minusExpression.accept());
    }

    @Test
    public void testEvaluateTimestampMinusTimestamp() {
        BeamSqlDatetimeMinusExpression minusExpression = BeamSqlDatetimeMinusExpressionTest.minusExpression(SqlTypeName.INTERVAL_SECOND, new BeamSqlExpression[]{TIMESTAMP, TIMESTAMP_MINUS_2_SEC});
        BeamSqlPrimitive subtractionResult = minusExpression.evaluate(NULL_ROW, NULL_WINDOW, BeamSqlExpressionEnvironments.empty());
        Assert.assertEquals((Object)((Object)SqlTypeName.BIGINT), (Object)((Object)subtractionResult.getOutputType()));
        Assert.assertEquals((long)(2L * TimeUnit.SECOND.multiplier.longValue()), (long)subtractionResult.getLong());
    }

    @Test
    public void testEvaluateTimestampMinusInteval() {
        BeamSqlDatetimeMinusExpression minusExpression = BeamSqlDatetimeMinusExpressionTest.minusExpression(SqlTypeName.TIMESTAMP, new BeamSqlExpression[]{TIMESTAMP, INTERVAL_2_SEC});
        BeamSqlPrimitive subtractionResult = minusExpression.evaluate(NULL_ROW, NULL_WINDOW, BeamSqlExpressionEnvironments.empty());
        Assert.assertEquals((Object)((Object)SqlTypeName.TIMESTAMP), (Object)((Object)subtractionResult.getOutputType()));
        Assert.assertEquals((Object)DATE_MINUS_2_SEC, (Object)subtractionResult.getDate());
    }

    @Test
    public void testEvaluateDateMinusInteval() {
        BeamSqlDatetimeMinusExpression minusExpression = BeamSqlDatetimeMinusExpressionTest.minusExpression(SqlTypeName.TIMESTAMP, new BeamSqlExpression[]{DATE1, INTERVAL_2_SEC});
        BeamSqlPrimitive subtractionResult = minusExpression.evaluate(NULL_ROW, NULL_WINDOW, BeamSqlExpressionEnvironments.empty());
        Assert.assertEquals((Object)((Object)SqlTypeName.TIMESTAMP), (Object)((Object)subtractionResult.getOutputType()));
        Assert.assertEquals((Object)DATE_MINUS_2_SEC, (Object)subtractionResult.getDate());
    }

    private static BeamSqlDatetimeMinusExpression minusExpression(SqlTypeName outputType, BeamSqlExpression ... operands) {
        return new BeamSqlDatetimeMinusExpression(Arrays.asList(operands), outputType);
    }
}

