/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.collection;

import java.util.Arrays;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironments;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.collection.BeamSqlSingleElementExpression;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.junit.Assert;
import org.junit.Test;

public class BeamSqlSingleElementExpressionTest {
    private static final Row NULL_ROW = null;
    private static final BoundedWindow NULL_WINDOW = null;

    @Test
    public void testReturnsSingleElement() {
        ImmutableList<BeamSqlPrimitive> input = ImmutableList.of(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.ARRAY, Arrays.asList("aaa")));
        BeamSqlSingleElementExpression expression = new BeamSqlSingleElementExpression(input, SqlTypeName.VARCHAR);
        Assert.assertEquals((Object)"aaa", (Object)expression.evaluate(NULL_ROW, NULL_WINDOW, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testReturnsNullForEmptyInput() {
        ImmutableList<BeamSqlPrimitive> input = ImmutableList.of(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.ARRAY, Arrays.asList(new Object[0])));
        BeamSqlSingleElementExpression expression = new BeamSqlSingleElementExpression(input, SqlTypeName.VARCHAR);
        Assert.assertNull((Object)expression.evaluate(NULL_ROW, NULL_WINDOW, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testAcceptsOneOperand() {
        ImmutableList<BeamSqlPrimitive> input = ImmutableList.of(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.ARRAY, Arrays.asList("aaa")));
        BeamSqlSingleElementExpression expression = new BeamSqlSingleElementExpression(input, SqlTypeName.VARCHAR);
        Assert.assertTrue((boolean)expression.accept());
    }

    @Test
    public void testRejectsMoreThanOneOperand() {
        ImmutableList<BeamSqlPrimitive> input = ImmutableList.of(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.ARRAY, Arrays.asList("aaa")), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.ARRAY, Arrays.asList("aaa")));
        BeamSqlSingleElementExpression expression = new BeamSqlSingleElementExpression(input, SqlTypeName.VARCHAR);
        Assert.assertFalse((boolean)expression.accept());
    }
}

