/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.collection;

import java.util.Arrays;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironments;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.collection.BeamSqlCardinalityExpression;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.junit.Assert;
import org.junit.Test;

public class BeamSqlCardinalityExpressionTest {
    private static final Row NULL_ROW = null;
    private static final BoundedWindow NULL_WINDOW = null;

    @Test
    public void testReturnsCardinalityForTwoElements() {
        ImmutableList<BeamSqlPrimitive> inputWith2Elements = ImmutableList.of(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.ARRAY, Arrays.asList("aaa", "bbb")));
        BeamSqlCardinalityExpression expression = new BeamSqlCardinalityExpression(inputWith2Elements, SqlTypeName.INTEGER);
        Assert.assertEquals((Object)2, (Object)expression.evaluate(NULL_ROW, NULL_WINDOW, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testReturnsCardinalityForZeroElements() {
        ImmutableList<BeamSqlPrimitive> emptyInput = ImmutableList.of(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.ARRAY, Arrays.asList(new Object[0])));
        BeamSqlCardinalityExpression expression = new BeamSqlCardinalityExpression(emptyInput, SqlTypeName.INTEGER);
        Assert.assertEquals((Object)0, (Object)expression.evaluate(NULL_ROW, NULL_WINDOW, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testAcceptsOneOperand() {
        ImmutableList<BeamSqlPrimitive> input = ImmutableList.of(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.ARRAY, Arrays.asList("aaa", "bbb")));
        BeamSqlCardinalityExpression expression = new BeamSqlCardinalityExpression(input, SqlTypeName.INTEGER);
        Assert.assertTrue((boolean)expression.accept());
    }

    @Test
    public void testRejectsTwoOperands() {
        ImmutableList<BeamSqlPrimitive> input = ImmutableList.of(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.ARRAY, Arrays.asList("aaa", "bbb")), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.ARRAY, Arrays.asList("aaa", "bbb")));
        BeamSqlCardinalityExpression expression = new BeamSqlCardinalityExpression(input, SqlTypeName.INTEGER);
        Assert.assertFalse((boolean)expression.accept());
    }
}

