/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.array;

import java.util.Arrays;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironments;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.array.BeamSqlArrayItemExpression;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.junit.Assert;
import org.junit.Test;

public class BeamSqlArrayItemExpressionTest {
    private static final Row NULL_ROW = null;
    private static final BoundedWindow NULL_WINDOW = null;

    @Test
    public void testAccessesElement0() {
        ImmutableList<BeamSqlPrimitive> input = ImmutableList.of(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.ARRAY, Arrays.asList("aaa", "bbb")), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)0));
        BeamSqlArrayItemExpression expression = new BeamSqlArrayItemExpression(input, SqlTypeName.VARCHAR);
        Assert.assertEquals((Object)"aaa", (Object)expression.evaluate(NULL_ROW, NULL_WINDOW, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testAccessesElement1() {
        ImmutableList<BeamSqlPrimitive> input = ImmutableList.of(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.ARRAY, Arrays.asList("aaa", "bbb")), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)1));
        BeamSqlArrayItemExpression expression = new BeamSqlArrayItemExpression(input, SqlTypeName.VARCHAR);
        Assert.assertEquals((Object)"bbb", (Object)expression.evaluate(NULL_ROW, NULL_WINDOW, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testAcceptsTwoOperands() {
        ImmutableList<BeamSqlPrimitive> input = ImmutableList.of(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.ARRAY, Arrays.asList("aaa", "bbb")), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)1));
        BeamSqlArrayItemExpression expression = new BeamSqlArrayItemExpression(input, SqlTypeName.VARCHAR);
        Assert.assertTrue((boolean)expression.accept());
    }

    @Test
    public void testRejectsLessThanTwoOperands() {
        ImmutableList<BeamSqlPrimitive> input = ImmutableList.of(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.ARRAY, Arrays.asList("aaa", "bbb")));
        BeamSqlArrayItemExpression expression = new BeamSqlArrayItemExpression(input, SqlTypeName.VARCHAR);
        Assert.assertFalse((boolean)expression.accept());
    }
}

