/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.array;

import java.util.Arrays;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironments;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.array.BeamSqlArrayExpression;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.junit.Assert;
import org.junit.Test;

public class BeamSqlArrayExpressionTest {
    private static final Row NULL_ROW = null;
    private static final BoundedWindow NULL_WINDOW = null;

    @Test
    public void testEvaluatesToList() {
        ImmutableList<BeamSqlPrimitive> elements = ImmutableList.of(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"aaa"), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"bbb"));
        BeamSqlArrayExpression arrayExpression = new BeamSqlArrayExpression(elements);
        Assert.assertEquals(Arrays.asList("aaa", "bbb"), (Object)arrayExpression.evaluate(NULL_ROW, NULL_WINDOW, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testAcceptsElementsWithOneType() {
        ImmutableList<BeamSqlPrimitive> elements = ImmutableList.of(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"aaa"), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"bbb"));
        BeamSqlArrayExpression arrayExpression = new BeamSqlArrayExpression(elements);
        Assert.assertTrue((boolean)arrayExpression.accept());
    }

    @Test
    public void testAcceptsElementsWithMultipleTypes() {
        ImmutableList<BeamSqlPrimitive> elements = ImmutableList.of(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"aaa"), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.CHAR, (Object)"bbb"));
        BeamSqlArrayExpression arrayExpression = new BeamSqlArrayExpression(elements);
        Assert.assertFalse((boolean)arrayExpression.accept());
    }
}

