/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator;

import java.util.Arrays;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironments;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlFnExecutorTestBase;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.reinterpret.BeamSqlReinterpretExpression;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class BeamSqlReinterpretExpressionTest
extends BeamSqlFnExecutorTestBase {
    private static final long DATE_LONG = 1000L;
    private static final DateTime DATE = new DateTime(1000L);
    private static final DateTime TIME = new DateTime().withDate(2019, 8, 9);
    private static final Row NULL_ROW = null;
    private static final BoundedWindow NULL_WINDOW = null;
    private static final BeamSqlExpression DATE_PRIMITIVE = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DATE, (Object)DATE);
    private static final BeamSqlExpression TIME_PRIMITIVE = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.TIME, (Object)TIME);
    private static final BeamSqlExpression TIMESTAMP_PRIMITIVE = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.TIMESTAMP, (Object)DATE);
    private static final BeamSqlExpression TINYINT_PRIMITIVE_5 = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.TINYINT, (Object)5);
    private static final BeamSqlExpression SMALLINT_PRIMITIVE_6 = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.SMALLINT, (Object)6);
    private static final BeamSqlExpression INTEGER_PRIMITIVE_8 = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)8);
    private static final BeamSqlExpression BIGINT_PRIMITIVE_15 = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BIGINT, (Object)15L);
    private static final BeamSqlExpression VARCHAR_PRIMITIVE = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"hello");

    @Test
    public void testAcceptsDateTypes() throws Exception {
        Assert.assertTrue((boolean)BeamSqlReinterpretExpressionTest.reinterpretExpression(DATE_PRIMITIVE).accept());
        Assert.assertTrue((boolean)BeamSqlReinterpretExpressionTest.reinterpretExpression(TIMESTAMP_PRIMITIVE).accept());
    }

    @Test
    public void testAcceptsTime() {
        Assert.assertTrue((boolean)BeamSqlReinterpretExpressionTest.reinterpretExpression(TIME_PRIMITIVE).accept());
    }

    @Test
    public void testAcceptsIntTypes() {
        Assert.assertTrue((boolean)BeamSqlReinterpretExpressionTest.reinterpretExpression(TINYINT_PRIMITIVE_5).accept());
        Assert.assertTrue((boolean)BeamSqlReinterpretExpressionTest.reinterpretExpression(SMALLINT_PRIMITIVE_6).accept());
        Assert.assertTrue((boolean)BeamSqlReinterpretExpressionTest.reinterpretExpression(INTEGER_PRIMITIVE_8).accept());
        Assert.assertTrue((boolean)BeamSqlReinterpretExpressionTest.reinterpretExpression(BIGINT_PRIMITIVE_15).accept());
    }

    @Test
    public void testDoesNotAcceptUnsupportedType() {
        Assert.assertFalse((boolean)BeamSqlReinterpretExpressionTest.reinterpretExpression(VARCHAR_PRIMITIVE).accept());
    }

    @Test
    public void testHasCorrectOutputType() {
        BeamSqlReinterpretExpression reinterpretExpression1 = new BeamSqlReinterpretExpression(Arrays.asList(DATE_PRIMITIVE), SqlTypeName.BIGINT);
        Assert.assertEquals((Object)((Object)SqlTypeName.BIGINT), (Object)((Object)reinterpretExpression1.getOutputType()));
        BeamSqlReinterpretExpression reinterpretExpression2 = new BeamSqlReinterpretExpression(Arrays.asList(DATE_PRIMITIVE), SqlTypeName.INTERVAL_YEAR);
        Assert.assertEquals((Object)((Object)SqlTypeName.INTERVAL_YEAR), (Object)((Object)reinterpretExpression2.getOutputType()));
    }

    @Test
    public void evaluateDate() {
        Assert.assertEquals((long)1000L, (long)BeamSqlReinterpretExpressionTest.evaluateReinterpretExpression(DATE_PRIMITIVE));
        Assert.assertEquals((long)1000L, (long)BeamSqlReinterpretExpressionTest.evaluateReinterpretExpression(TIMESTAMP_PRIMITIVE));
    }

    @Test
    public void evaluateTime() {
        Assert.assertEquals((long)TIME.getMillis(), (long)BeamSqlReinterpretExpressionTest.evaluateReinterpretExpression(TIME_PRIMITIVE));
    }

    @Test
    public void evaluateInts() {
        Assert.assertEquals((long)5L, (long)BeamSqlReinterpretExpressionTest.evaluateReinterpretExpression(TINYINT_PRIMITIVE_5));
        Assert.assertEquals((long)6L, (long)BeamSqlReinterpretExpressionTest.evaluateReinterpretExpression(SMALLINT_PRIMITIVE_6));
        Assert.assertEquals((long)8L, (long)BeamSqlReinterpretExpressionTest.evaluateReinterpretExpression(INTEGER_PRIMITIVE_8));
        Assert.assertEquals((long)15L, (long)BeamSqlReinterpretExpressionTest.evaluateReinterpretExpression(BIGINT_PRIMITIVE_15));
    }

    private static long evaluateReinterpretExpression(BeamSqlExpression operand) {
        return BeamSqlReinterpretExpressionTest.reinterpretExpression(operand).evaluate(NULL_ROW, NULL_WINDOW, BeamSqlExpressionEnvironments.empty()).getLong();
    }

    private static BeamSqlReinterpretExpression reinterpretExpression(BeamSqlExpression ... operands) {
        return new BeamSqlReinterpretExpression(Arrays.asList(operands), SqlTypeName.BIGINT);
    }
}

