/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator;

import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util.ByteString;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironments;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlFnExecutorTestBase;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.junit.Assert;
import org.junit.Test;

public class BeamSqlPrimitiveTest
extends BeamSqlFnExecutorTestBase {
    @Test
    public void testPrimitiveInt() {
        BeamSqlPrimitive expInt = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)100);
        Assert.assertEquals((Object)expInt.getValue(), (Object)expInt.evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testPrimitiveBytes1() {
        BeamSqlPrimitive expBytes = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARBINARY, (Object)new byte[]{1, 2, 3});
        Assert.assertEquals((Object)expBytes.getValue(), (Object)expBytes.evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testPrimitiveBytes2() {
        BeamSqlPrimitive expBytes = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARBINARY, (Object)ByteString.of("123ABC", 16));
        Assert.assertEquals((Object)expBytes.getValue(), (Object)expBytes.evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrimitiveTypeUnMatch1() {
        BeamSqlPrimitive expInt = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)100L);
        Assert.assertEquals((Object)expInt.getValue(), (Object)expInt.evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrimitiveTypeUnMatch2() {
        BeamSqlPrimitive expInt = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DECIMAL, (Object)100L);
        Assert.assertEquals((Object)expInt.getValue(), (Object)expInt.evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrimitiveTypeUnMatch3() {
        BeamSqlPrimitive expInt = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.FLOAT, (Object)100L);
        Assert.assertEquals((Object)expInt.getValue(), (Object)expInt.evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrimitiveTypeUnMatch4() {
        BeamSqlPrimitive expInt = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)100L);
        Assert.assertEquals((Object)expInt.getValue(), (Object)expInt.evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrimitiveTypeUnMatch5() {
        BeamSqlPrimitive expBytes = BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARBINARY, (Object)100L);
        Assert.assertEquals((Object)expBytes.getValue(), (Object)expBytes.evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }
}

