/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator;

import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironments;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlFnExecutorTestBase;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlInputRefExpression;
import org.junit.Assert;
import org.junit.Test;

public class BeamSqlInputRefExpressionTest
extends BeamSqlFnExecutorTestBase {
    @Test
    public void testRefInRange() {
        BeamSqlInputRefExpression ref0 = new BeamSqlInputRefExpression(SqlTypeName.BIGINT, 0);
        Assert.assertEquals((Object)row.getInt64(0), (Object)ref0.evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        BeamSqlInputRefExpression ref1 = new BeamSqlInputRefExpression(SqlTypeName.INTEGER, 1);
        Assert.assertEquals((Object)row.getInt32(1), (Object)ref1.evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        BeamSqlInputRefExpression ref2 = new BeamSqlInputRefExpression(SqlTypeName.DOUBLE, 2);
        Assert.assertEquals((Object)row.getDouble(2), (Object)ref2.evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        BeamSqlInputRefExpression ref3 = new BeamSqlInputRefExpression(SqlTypeName.BIGINT, 3);
        Assert.assertEquals((Object)row.getInt64(3), (Object)ref3.evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRefOutOfRange() {
        BeamSqlInputRefExpression ref = new BeamSqlInputRefExpression(SqlTypeName.BIGINT, 5);
        ref.evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTypeUnMatch() {
        BeamSqlInputRefExpression ref = new BeamSqlInputRefExpression(SqlTypeName.INTEGER, 0);
        ref.evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue();
    }
}

