/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator;

import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironments;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlDotExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BeamSqlDotExpressionTest {
    private static final Row NULL_ROW = null;
    private static final BoundedWindow NULL_WINDOW = null;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testReturnsFieldValue() {
        Schema schema = Schema.builder().addStringField("f_string").addInt32Field("f_int").build();
        ImmutableList<BeamSqlPrimitive> elements = ImmutableList.of(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.ROW, (Object)Row.withSchema((Schema)schema).addValues(new Object[]{"aaa", 14}).build()), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"f_string"));
        BeamSqlDotExpression arrayExpression = new BeamSqlDotExpression(elements, SqlTypeName.VARCHAR);
        Assert.assertEquals((Object)"aaa", (Object)arrayExpression.evaluate(NULL_ROW, NULL_WINDOW, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testThrowsForNonExistentField() {
        Schema schema = Schema.builder().addStringField("f_string").addInt32Field("f_int").build();
        ImmutableList<BeamSqlPrimitive> elements = ImmutableList.of(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.ROW, (Object)Row.withSchema((Schema)schema).addValues(new Object[]{"aaa", 14}).build()), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"f_nonExistent"));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Cannot find field");
        new BeamSqlDotExpression(elements, SqlTypeName.VARCHAR).evaluate(NULL_ROW, NULL_WINDOW, BeamSqlExpressionEnvironments.empty());
    }
}

