/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironments;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlFnExecutorTestBase;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlCastExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BeamSqlCastExpressionTest
extends BeamSqlFnExecutorTestBase {
    private List<BeamSqlExpression> operands;

    @Before
    public void setup() {
        this.operands = new ArrayList<BeamSqlExpression>();
    }

    @Test
    public void testForOperands() {
        this.operands.add((BeamSqlExpression)BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)1));
        this.operands.add((BeamSqlExpression)BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"aaa"));
        Assert.assertFalse((boolean)new BeamSqlCastExpression(this.operands, SqlTypeName.BIGINT).accept());
    }

    @Test
    public void testForIntegerToBigintTypeCasting() {
        this.operands.add((BeamSqlExpression)BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)5));
        Assert.assertEquals((long)5L, (long)new BeamSqlCastExpression(this.operands, SqlTypeName.BIGINT).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getLong());
    }

    @Test
    public void testForDoubleToBigIntCasting() {
        this.operands.add((BeamSqlExpression)BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.DOUBLE, (Object)5.45));
        Assert.assertEquals((long)5L, (long)new BeamSqlCastExpression(this.operands, SqlTypeName.BIGINT).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getLong());
    }

    @Test
    public void testForIntegerToDateCast() {
        this.operands.add((BeamSqlExpression)BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)20170521));
        Assert.assertEquals((Object)new DateTime().withDate(2017, 5, 21).withTimeAtStartOfDay(), (Object)new BeamSqlCastExpression(this.operands, SqlTypeName.DATE).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testyyyyMMddDateFormat() {
        this.operands.add((BeamSqlExpression)BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"2017-05-21"));
        Assert.assertEquals((Object)new DateTime().withDate(2017, 5, 21).withTimeAtStartOfDay(), (Object)new BeamSqlCastExpression(this.operands, SqlTypeName.DATE).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testyyMMddDateFormat() {
        this.operands.add((BeamSqlExpression)BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"17.05.21"));
        Assert.assertEquals((Object)new DateTime().withDate(2017, 5, 21).withTimeAtStartOfDay(), (Object)new BeamSqlCastExpression(this.operands, SqlTypeName.DATE).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testForTimestampCastExpression() {
        this.operands.add((BeamSqlExpression)BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"17-05-21 23:59:59.989"));
        Assert.assertEquals((Object)((Object)SqlTypeName.TIMESTAMP), (Object)((Object)new BeamSqlCastExpression(this.operands, SqlTypeName.TIMESTAMP).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getOutputType()));
    }

    @Test
    public void testDateTimeFormatWithMillis() {
        this.operands.add((BeamSqlExpression)BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"2017-05-21 23:59:59.989"));
        Assert.assertEquals((Object)new DateTime().withDate(2017, 5, 22).withTime(0, 0, 0, 0), (Object)new BeamSqlCastExpression(this.operands, SqlTypeName.TIMESTAMP).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testDateTimeFormatWithTimezone() {
        this.operands.add((BeamSqlExpression)BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"2017-05-21 23:59:59.89079 PST"));
        DateTime expected = new DateTime().withZone(DateTimeZone.forID((String)"US/Pacific")).withDate(2017, 5, 22).withTime(0, 0, 0, 0);
        Assert.assertEquals((Object)expected, (Object)new BeamSqlCastExpression(this.operands, SqlTypeName.TIMESTAMP).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test
    public void testDateTimeFormat() {
        this.operands.add((BeamSqlExpression)BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"2017-05-21 23:59:59"));
        Assert.assertEquals((Object)new DateTime().withDate(2017, 5, 21).withTime(23, 59, 59, 0), (Object)new BeamSqlCastExpression(this.operands, SqlTypeName.TIMESTAMP).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }

    @Test(expected=RuntimeException.class)
    public void testForCastTypeNotSupported() {
        this.operands.add((BeamSqlExpression)BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.TIME, (Object)DateTime.now()));
        Assert.assertEquals((Object)new DateTime().withDate(2017, 5, 22).withTime(0, 0, 0, 0), (Object)new BeamSqlCastExpression(this.operands, SqlTypeName.TIMESTAMP).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }
}

