/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator;

import java.util.ArrayList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironments;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlFnExecutorTestBase;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlCaseExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.junit.Assert;
import org.junit.Test;

public class BeamSqlCaseExpressionTest
extends BeamSqlFnExecutorTestBase {
    @Test
    public void accept() throws Exception {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BOOLEAN, (Object)true));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"hello"));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"world"));
        Assert.assertTrue((boolean)new BeamSqlCaseExpression(operands).accept());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BOOLEAN, (Object)true));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"world"));
        Assert.assertFalse((boolean)new BeamSqlCaseExpression(operands).accept());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"error"));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"hello"));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"world"));
        Assert.assertFalse((boolean)new BeamSqlCaseExpression(operands).accept());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BOOLEAN, (Object)true));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"hello"));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BOOLEAN, (Object)true));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)10));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"hello"));
        Assert.assertFalse((boolean)new BeamSqlCaseExpression(operands).accept());
    }

    @Test
    public void evaluate() throws Exception {
        ArrayList<BeamSqlPrimitive> operands = new ArrayList<BeamSqlPrimitive>();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BOOLEAN, (Object)true));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"hello"));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"world"));
        Assert.assertEquals((Object)"hello", (Object)new BeamSqlCaseExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BOOLEAN, (Object)false));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"hello"));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"world"));
        Assert.assertEquals((Object)"world", (Object)new BeamSqlCaseExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
        operands.clear();
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BOOLEAN, (Object)false));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"hello"));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.BOOLEAN, (Object)true));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"hello1"));
        operands.add(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.VARCHAR, (Object)"world"));
        Assert.assertEquals((Object)"hello1", (Object)new BeamSqlCaseExpression(operands).evaluate(row, null, BeamSqlExpressionEnvironments.empty()).getValue());
    }
}

