/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter;

import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.config.Lex;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.Contexts;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.ConventionTraitDef;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelTraitDef;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.parser.SqlParser;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.tools.FrameworkConfig;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.tools.Frameworks;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.tools.RelBuilder;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRuleSets;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.junit.BeforeClass;

public class BeamSqlFnExecutorTestBase {
    static final JavaTypeFactory TYPE_FACTORY = new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
    static RexBuilder rexBuilder = new RexBuilder(TYPE_FACTORY);
    static RelOptCluster cluster = RelOptCluster.create(new VolcanoPlanner(), rexBuilder);
    static RelDataType relDataType;
    static RelBuilder relBuilder;
    public static Row row;

    @BeforeClass
    public static void prepare() {
        relDataType = TYPE_FACTORY.builder().add("order_id", SqlTypeName.BIGINT).add("site_id", SqlTypeName.INTEGER).add("price", SqlTypeName.DOUBLE).add("order_time", SqlTypeName.BIGINT).add("order_info", SqlTypeName.VARCHAR).build();
        row = Row.withSchema((Schema)CalciteUtils.toSchema((RelDataType)relDataType)).addValues(new Object[]{1234567L, 0, 8.9, 1234567L, "This is an order."}).build();
        SchemaPlus schema = Frameworks.createRootSchema(true);
        ImmutableList<RelTraitDef> traitDefs = ImmutableList.of(ConventionTraitDef.INSTANCE);
        FrameworkConfig config = Frameworks.newConfigBuilder().parserConfig(SqlParser.configBuilder().setLex(Lex.MYSQL).build()).defaultSchema(schema).traitDefs(traitDefs).context(Contexts.EMPTY_CONTEXT).ruleSets(BeamRuleSets.getRuleSets()).costFactory(null).typeSystem(TYPE_FACTORY.getTypeSystem()).build();
        try {
            Class.forName("org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        relBuilder = RelBuilder.create(config);
    }
}

