/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util.TimeUnit;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.BasicSqlType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlFnExecutor;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlFnExecutorTestBase;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.arithmetic.BeamSqlDivideExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.arithmetic.BeamSqlMinusExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.arithmetic.BeamSqlModExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.arithmetic.BeamSqlMultiplyExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.arithmetic.BeamSqlPlusExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlCurrentDateExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlCurrentTimeExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlCurrentTimestampExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlDatetimeMinusExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlDatetimePlusExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlIntervalMultiplyExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.logical.BeamSqlAndExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.logical.BeamSqlNotExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.logical.BeamSqlOrExpression;
import org.junit.Assert;
import org.junit.Test;

public class BeamSqlFnExecutorTest
extends BeamSqlFnExecutorTestBase {
    @Test
    public void testBuildExpression_logical() {
        RexNode rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, Arrays.asList(rexBuilder.makeLiteral(true), rexBuilder.makeLiteral(false)));
        BeamSqlExpression exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlAndExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, Arrays.asList(rexBuilder.makeLiteral(true), rexBuilder.makeLiteral(false)));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlOrExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, Arrays.asList(rexBuilder.makeLiteral(true)));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlNotExpression));
    }

    @Test(expected=IllegalStateException.class)
    public void testBuildExpression_logical_andOr_invalidOperand() {
        RexNode rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, Arrays.asList(rexBuilder.makeLiteral(true), rexBuilder.makeLiteral("hello")));
        BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
    }

    @Test(expected=IllegalStateException.class)
    public void testBuildExpression_logical_not_invalidOperand() {
        RexNode rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, Arrays.asList(rexBuilder.makeLiteral("hello")));
        BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
    }

    @Test
    public void testBuildExpression_literal() {
        BasicSqlType realType = new BasicSqlType(RelDataTypeSystem.DEFAULT, SqlTypeName.INTEGER);
        RexLiteral rexNode = RexLiteral.fromJdbcString(realType, SqlTypeName.DOUBLE, "1.0");
        BeamSqlExpression exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlPrimitive));
        Assert.assertEquals((Object)((Object)SqlTypeName.INTEGER), (Object)((Object)exp.getOutputType()));
    }

    @Test(expected=IllegalStateException.class)
    public void testBuildExpression_literal_mismatch_type() {
        BasicSqlType realType = new BasicSqlType(RelDataTypeSystem.DEFAULT, SqlTypeName.VARCHAR);
        RexLiteral rexNode = RexLiteral.fromJdbcString(realType, SqlTypeName.DOUBLE, "1.0");
        BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
    }

    @Test
    public void testBuildExpression_arithmetic() {
        this.testBuildArithmeticExpression(SqlStdOperatorTable.PLUS, BeamSqlPlusExpression.class);
        this.testBuildArithmeticExpression(SqlStdOperatorTable.MINUS, BeamSqlMinusExpression.class);
        this.testBuildArithmeticExpression(SqlStdOperatorTable.MULTIPLY, BeamSqlMultiplyExpression.class);
        this.testBuildArithmeticExpression(SqlStdOperatorTable.DIVIDE, BeamSqlDivideExpression.class);
        this.testBuildArithmeticExpression(SqlStdOperatorTable.MOD, BeamSqlModExpression.class);
    }

    private void testBuildArithmeticExpression(SqlOperator fn, Class<? extends BeamSqlExpression> clazz) {
        RexNode rexNode = rexBuilder.makeCall(fn, Arrays.asList(rexBuilder.makeBigintLiteral(BigDecimal.ONE), rexBuilder.makeBigintLiteral(BigDecimal.ONE)));
        BeamSqlExpression exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)exp.getClass().equals(clazz));
    }

    @Test
    public void testBuildExpression_date() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendar.setTime(new Date());
        RexNode rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CURRENT_DATE, Arrays.asList(new RexNode[0]));
        BeamSqlExpression exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlCurrentDateExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LOCALTIME, Arrays.asList(new RexNode[0]));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlCurrentTimeExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LOCALTIMESTAMP, Arrays.asList(new RexNode[0]));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlCurrentTimestampExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DATETIME_PLUS, Arrays.asList(rexBuilder.makeDateLiteral(calendar), rexBuilder.makeIntervalLiteral(BigDecimal.TEN, new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.DAY, SqlParserPos.ZERO))));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlDatetimePlusExpression));
        rexNode = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, Arrays.asList(rexBuilder.makeExactLiteral(BigDecimal.ONE), rexBuilder.makeIntervalLiteral(BigDecimal.TEN, new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.DAY, SqlParserPos.ZERO))));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlIntervalMultiplyExpression));
        rexNode = rexBuilder.makeCall(TYPE_FACTORY.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.DAY, SqlParserPos.ZERO)), SqlStdOperatorTable.MINUS, Arrays.asList(rexBuilder.makeTimestampLiteral(Calendar.getInstance(), 1000), rexBuilder.makeTimestampLiteral(Calendar.getInstance(), 1000)));
        exp = BeamSqlFnExecutor.buildExpression((RexNode)rexNode);
        Assert.assertTrue((boolean)(exp instanceof BeamSqlDatetimeMinusExpression));
    }
}

