/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.jdbc.CalciteConnection;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchema;
import org.apache.beam.sdk.extensions.sql.impl.JdbcDriver;
import org.apache.beam.sdk.extensions.sql.meta.provider.ReadOnlyTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestTableProvider;
import org.apache.beam.sdk.extensions.sql.mock.MockedBoundedTable;
import org.apache.beam.sdk.extensions.sql.mock.MockedUnboundedTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JdbcDriverTest {
    public static final DateTime FIRST_DATE = new DateTime(1L);
    private static final Schema BASIC_SCHEMA = Schema.builder().addNullableField("id", Schema.FieldType.INT64).addNullableField("name", Schema.FieldType.STRING).build();
    private static final Schema COMPLEX_SCHEMA = Schema.builder().addNullableField("description", Schema.FieldType.STRING).addNullableField("nestedRow", Schema.FieldType.row((Schema)BASIC_SCHEMA)).build();
    private static final ReadOnlyTableProvider BOUNDED_TABLE = new ReadOnlyTableProvider("test", ImmutableMap.of("test", MockedBoundedTable.of(Schema.FieldType.INT32, "id", Schema.FieldType.STRING, "name").addRows(1, "first")));
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void before() throws Exception {
        Class.forName("org.apache.beam.sdk.extensions.sql.impl.JdbcDriver");
    }

    @Test
    public void testDriverManager_getDriver() throws Exception {
        Driver driver = DriverManager.getDriver("jdbc:beam:");
        Assert.assertTrue((boolean)(driver instanceof JdbcDriver));
    }

    @Test
    public void testDriverManager_simple() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:beam:");
        Statement statement = connection.createStatement();
        Assert.assertTrue((boolean)statement.execute("SELECT 1"));
    }

    @Test
    public void testDriverManager_defaultUserAgent() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:beam:");
        SchemaPlus rootSchema = ((CalciteConnection)connection).getRootSchema();
        BeamCalciteSchema beamSchema = (BeamCalciteSchema)CalciteSchema.from((SchemaPlus)rootSchema.getSubSchema((String)"beam")).schema;
        Map pipelineOptions = beamSchema.getPipelineOptions();
        Assert.assertThat((Object)((String)pipelineOptions.get("userAgent")), (Matcher)Matchers.containsString((String)"BeamSQL"));
    }

    @Test
    public void testDriverManager_setUserAgent() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:beam:beam.userAgent=Secret Agent");
        SchemaPlus rootSchema = ((CalciteConnection)connection).getRootSchema();
        BeamCalciteSchema beamSchema = (BeamCalciteSchema)CalciteSchema.from((SchemaPlus)rootSchema.getSubSchema((String)"beam")).schema;
        Map pipelineOptions = beamSchema.getPipelineOptions();
        Assert.assertThat((Object)((String)pipelineOptions.get("userAgent")), (Matcher)Matchers.equalTo((Object)"Secret Agent"));
    }

    @Test
    public void testDriverManager_pipelineOptionsPlumbing() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:beam:beam.foo=baz;beam.foobizzle=mahshizzle;other=smother");
        SchemaPlus rootSchema = ((CalciteConnection)connection).getRootSchema();
        BeamCalciteSchema beamSchema = (BeamCalciteSchema)CalciteSchema.from((SchemaPlus)rootSchema.getSubSchema((String)"beam")).schema;
        Map pipelineOptions = beamSchema.getPipelineOptions();
        Assert.assertThat((Object)((String)pipelineOptions.get("foo")), (Matcher)Matchers.equalTo((Object)"baz"));
        Assert.assertThat((Object)((String)pipelineOptions.get("foobizzle")), (Matcher)Matchers.equalTo((Object)"mahshizzle"));
        Assert.assertThat((Object)((String)pipelineOptions.get("other")), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testDriverManager_parse() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:beam:");
        Statement statement = connection.createStatement();
        Assert.assertTrue((boolean)statement.execute("SELECT 'beam'"));
    }

    @Test
    public void testDriverManager_ddl() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:beam:");
        DatabaseMetaData metadata = connection.getMetaData();
        ResultSet resultSet = metadata.getTables(null, null, null, new String[]{"TABLE"});
        Assert.assertFalse((boolean)resultSet.next());
        Statement statement = connection.createStatement();
        Assert.assertEquals((long)0L, (long)statement.executeUpdate("CREATE TABLE test (id INTEGER) TYPE 'text'"));
        resultSet = metadata.getTables(null, null, null, new String[]{"TABLE"});
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((Object)"test", (Object)resultSet.getString("TABLE_NAME"));
        Assert.assertFalse((boolean)resultSet.next());
        Assert.assertEquals((long)0L, (long)statement.executeUpdate("DROP TABLE test"));
        resultSet = metadata.getTables(null, null, null, new String[]{"TABLE"});
        Assert.assertFalse((boolean)resultSet.next());
    }

    @Test
    public void testSelectsFromExistingTable() throws Exception {
        TestTableProvider tableProvider = new TestTableProvider();
        CalciteConnection connection = JdbcDriver.connect((TableProvider)tableProvider);
        connection.createStatement().executeUpdate("CREATE TABLE person (id BIGINT, name VARCHAR) TYPE 'test'");
        tableProvider.addRows("person", new Row[]{this.row(1L, "aaa"), this.row(2L, "bbb")});
        ResultSet selectResult = connection.createStatement().executeQuery("SELECT id, name FROM person");
        List resultRows = this.readResultSet(selectResult).stream().map(values -> (Row)values.stream().collect(Row.toRow((Schema)BASIC_SCHEMA))).collect(Collectors.toList());
        Assert.assertThat(resultRows, (Matcher)Matchers.containsInAnyOrder((Object[])new Row[]{this.row(1L, "aaa"), this.row(2L, "bbb")}));
    }

    @Test
    public void testTimestampWithDefaultTimezone() throws Exception {
        TestTableProvider tableProvider = new TestTableProvider();
        CalciteConnection connection = JdbcDriver.connect((TableProvider)tableProvider);
        Schema schema = Schema.builder().addDateTimeField("ts").build();
        connection.createStatement().executeUpdate("CREATE TABLE test (ts TIMESTAMP) TYPE 'test'");
        DateTime july1 = ISODateTimeFormat.dateTimeParser().parseDateTime("2018-07-01T01:02:03Z");
        tableProvider.addRows("test", new Row[]{Row.withSchema((Schema)schema).addValue((Object)july1).build()});
        ResultSet selectResult = connection.createStatement().executeQuery(String.format("SELECT ts FROM test", new Object[0]));
        selectResult.next();
        Timestamp ts = selectResult.getTimestamp(1);
        Assert.assertThat((String)String.format("Wrote %s to a table, but got back %s", ISODateTimeFormat.basicDateTime().print((ReadableInstant)july1), ISODateTimeFormat.basicDateTime().print(ts.getTime())), (Object)ts.getTime(), (Matcher)Matchers.equalTo((Object)july1.getMillis()));
    }

    @Test
    @Ignore(value="https://issues.apache.org/jira/browse/CALCITE-2394")
    public void testTimestampWithNonzeroTimezone() throws Exception {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("Asia/Tokyo"), Locale.ROOT);
        TestTableProvider tableProvider = new TestTableProvider();
        CalciteConnection connection = JdbcDriver.connect((TableProvider)tableProvider);
        Schema schema = Schema.builder().addDateTimeField("ts").build();
        connection.createStatement().executeUpdate("CREATE TABLE test (ts TIMESTAMP) TYPE 'test'");
        DateTime july1 = ISODateTimeFormat.dateTimeParser().parseDateTime("2018-07-01T01:02:03Z");
        tableProvider.addRows("test", new Row[]{Row.withSchema((Schema)schema).addValue((Object)july1).build()});
        ResultSet selectResult = connection.createStatement().executeQuery(String.format("SELECT ts FROM test", new Object[0]));
        selectResult.next();
        Timestamp ts = selectResult.getTimestamp(1, cal);
        Assert.assertThat((String)String.format("Wrote %s to a table, but got back %s", ISODateTimeFormat.basicDateTime().print((ReadableInstant)july1), ISODateTimeFormat.basicDateTime().print(ts.getTime())), (Object)ts.getTime(), (Matcher)Matchers.equalTo((Object)july1.getMillis()));
    }

    @Test
    public void testTimestampWithZeroTimezone() throws Exception {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT);
        TestTableProvider tableProvider = new TestTableProvider();
        CalciteConnection connection = JdbcDriver.connect((TableProvider)tableProvider);
        Schema schema = Schema.builder().addDateTimeField("ts").build();
        connection.createStatement().executeUpdate("CREATE TABLE test (ts TIMESTAMP) TYPE 'test'");
        DateTime july1 = ISODateTimeFormat.dateTimeParser().parseDateTime("2018-07-01T01:02:03Z");
        tableProvider.addRows("test", new Row[]{Row.withSchema((Schema)schema).addValue((Object)july1).build()});
        ResultSet selectResult = connection.createStatement().executeQuery(String.format("SELECT ts FROM test", new Object[0]));
        selectResult.next();
        Timestamp ts = selectResult.getTimestamp(1, cal);
        Assert.assertThat((String)String.format("Wrote %s to a table, but got back %s", ISODateTimeFormat.basicDateTime().print((ReadableInstant)july1), ISODateTimeFormat.basicDateTime().print(ts.getTime())), (Object)ts.getTime(), (Matcher)Matchers.equalTo((Object)july1.getMillis()));
    }

    @Test
    public void testSelectsFromExistingComplexTable() throws Exception {
        TestTableProvider tableProvider = new TestTableProvider();
        CalciteConnection connection = JdbcDriver.connect((TableProvider)tableProvider);
        connection.createStatement().executeUpdate("CREATE TABLE person ( \ndescription VARCHAR, \nnestedRow ROW< \n              id BIGINT, \n              name VARCHAR> \n) \nTYPE 'test'");
        tableProvider.addRows("person", new Row[]{this.row(COMPLEX_SCHEMA, new Object[]{"description1", this.row(1L, "aaa")}), this.row(COMPLEX_SCHEMA, new Object[]{"description2", this.row(2L, "bbb")})});
        ResultSet selectResult = connection.createStatement().executeQuery("SELECT person.nestedRow.id, person.nestedRow.name FROM person");
        List resultRows = this.readResultSet(selectResult).stream().map(values -> (Row)values.stream().collect(Row.toRow((Schema)BASIC_SCHEMA))).collect(Collectors.toList());
        Assert.assertThat(resultRows, (Matcher)Matchers.containsInAnyOrder((Object[])new Row[]{this.row(1L, "aaa"), this.row(2L, "bbb")}));
    }

    @Test
    public void testInsertIntoCreatedTable() throws Exception {
        TestTableProvider tableProvider = new TestTableProvider();
        CalciteConnection connection = JdbcDriver.connect((TableProvider)tableProvider);
        connection.createStatement().executeUpdate("CREATE TABLE person (id BIGINT, name VARCHAR) TYPE 'test'");
        connection.createStatement().executeUpdate("CREATE TABLE person_src (id BIGINT, name VARCHAR) TYPE 'test'");
        tableProvider.addRows("person_src", new Row[]{this.row(1L, "aaa"), this.row(2L, "bbb")});
        connection.createStatement().execute("INSERT INTO person SELECT id, name FROM person_src");
        ResultSet selectResult = connection.createStatement().executeQuery("SELECT id, name FROM person");
        List resultRows = this.readResultSet(selectResult).stream().map(resultValues -> (Row)resultValues.stream().collect(Row.toRow((Schema)BASIC_SCHEMA))).collect(Collectors.toList());
        Assert.assertThat(resultRows, (Matcher)Matchers.containsInAnyOrder((Object[])new Row[]{this.row(1L, "aaa"), this.row(2L, "bbb")}));
    }

    @Test
    public void testInternalConnect_boundedTable() throws Exception {
        CalciteConnection connection = JdbcDriver.connect((TableProvider)BOUNDED_TABLE);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT * FROM test");
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((long)1L, (long)resultSet.getInt("id"));
        Assert.assertEquals((Object)"first", (Object)resultSet.getString("name"));
        Assert.assertFalse((boolean)resultSet.next());
    }

    @Test
    public void testInternalConnect_bounded_limit() throws Exception {
        ReadOnlyTableProvider tableProvider = new ReadOnlyTableProvider("test", ImmutableMap.of("test", MockedBoundedTable.of(Schema.FieldType.INT32, "id", Schema.FieldType.STRING, "name").addRows(1, "first").addRows(1, "second first").addRows(2, "second")));
        CalciteConnection connection = JdbcDriver.connect((TableProvider)tableProvider);
        Statement statement = connection.createStatement();
        ResultSet resultSet1 = statement.executeQuery("SELECT * FROM test LIMIT 5");
        Assert.assertTrue((boolean)resultSet1.next());
        Assert.assertTrue((boolean)resultSet1.next());
        Assert.assertTrue((boolean)resultSet1.next());
        Assert.assertFalse((boolean)resultSet1.next());
        Assert.assertFalse((boolean)resultSet1.next());
        ResultSet resultSet2 = statement.executeQuery("SELECT * FROM test LIMIT 1");
        Assert.assertTrue((boolean)resultSet2.next());
        Assert.assertFalse((boolean)resultSet2.next());
        ResultSet resultSet3 = statement.executeQuery("SELECT * FROM test LIMIT 2");
        Assert.assertTrue((boolean)resultSet3.next());
        Assert.assertTrue((boolean)resultSet3.next());
        Assert.assertFalse((boolean)resultSet3.next());
        ResultSet resultSet4 = statement.executeQuery("SELECT * FROM test LIMIT 3");
        Assert.assertTrue((boolean)resultSet4.next());
        Assert.assertTrue((boolean)resultSet4.next());
        Assert.assertTrue((boolean)resultSet4.next());
        Assert.assertFalse((boolean)resultSet4.next());
    }

    @Test
    public void testInternalConnect_unbounded_limit() throws Exception {
        ReadOnlyTableProvider tableProvider = new ReadOnlyTableProvider("test", ImmutableMap.of("test", MockedUnboundedTable.of(Schema.FieldType.INT32, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.INT32, "price", Schema.FieldType.DATETIME, "order_time").timestampColumnIndex(3).addRows(Duration.ZERO, 1, 1, 1, FIRST_DATE, 1, 2, 6, FIRST_DATE)));
        CalciteConnection connection = JdbcDriver.connect((TableProvider)tableProvider);
        Statement statement = connection.createStatement();
        ResultSet resultSet1 = statement.executeQuery("SELECT * FROM test LIMIT 1");
        Assert.assertTrue((boolean)resultSet1.next());
        Assert.assertFalse((boolean)resultSet1.next());
        ResultSet resultSet2 = statement.executeQuery("SELECT * FROM test LIMIT 2");
        Assert.assertTrue((boolean)resultSet2.next());
        Assert.assertTrue((boolean)resultSet2.next());
        Assert.assertFalse((boolean)resultSet2.next());
    }

    private List<List<Object>> readResultSet(ResultSet result) throws Exception {
        ArrayList<List<Object>> results = new ArrayList<List<Object>>();
        while (result.next()) {
            ArrayList<Object> rowValues = new ArrayList<Object>();
            for (int i = 0; i < result.getMetaData().getColumnCount(); ++i) {
                rowValues.add(result.getObject(i + 1));
            }
            results.add(rowValues);
        }
        return results;
    }

    private Row row(Object ... values) {
        return this.row(BASIC_SCHEMA, values);
    }

    private Row row(Schema schema, Object ... values) {
        return Row.withSchema((Schema)schema).addValues(values).build();
    }

    @Test
    public void testInternalConnect_setDirectRunner() throws Exception {
        CalciteConnection connection = JdbcDriver.connect((TableProvider)BOUNDED_TABLE);
        Statement statement = connection.createStatement();
        Assert.assertEquals((long)0L, (long)statement.executeUpdate("SET runner = direct"));
        Assert.assertTrue((boolean)statement.execute("SELECT * FROM test"));
    }

    @Test
    public void testInternalConnect_setBogusRunner() throws Exception {
        this.thrown.expectMessage("Unknown 'runner' specified 'bogus'");
        CalciteConnection connection = JdbcDriver.connect((TableProvider)BOUNDED_TABLE);
        Statement statement = connection.createStatement();
        Assert.assertEquals((long)0L, (long)statement.executeUpdate("SET runner = bogus"));
        Assert.assertTrue((boolean)statement.execute("SELECT * FROM test"));
    }

    @Test
    public void testInternalConnect_resetAll() throws Exception {
        CalciteConnection connection = JdbcDriver.connect((TableProvider)BOUNDED_TABLE);
        Statement statement = connection.createStatement();
        Assert.assertEquals((long)0L, (long)statement.executeUpdate("SET runner = bogus"));
        Assert.assertEquals((long)0L, (long)statement.executeUpdate("RESET ALL"));
        Assert.assertTrue((boolean)statement.execute("SELECT * FROM test"));
    }
}

