/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.schemas.DefaultSchema;
import org.apache.beam.sdk.schemas.JavaBeanSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Rule;
import org.junit.Test;

public class InferredJavaBeanSqlTest {
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();

    @Test
    public void testSelect() {
        PCollection input = (PCollection)PBegin.in((Pipeline)this.pipeline).apply("input", (PTransform)Create.of((Object)new PersonBean("Foo", 5), (Object[])new PersonBean[]{new PersonBean("Bar", 53)}));
        String sql = "SELECT name, ageYears FROM PCOLLECTION";
        PCollection result = (PCollection)input.apply("sql", (PTransform)SqlTransform.query((String)sql));
        PAssert.that((PCollection)result).containsInAnyOrder(TestUtils.rowsBuilderOf(Schema.builder().addStringField("name").addInt32Field("ageYears").build()).addRows("Foo", 5, "Bar", 53).getRows());
        this.pipeline.run();
    }

    @Test
    public void testProject() {
        PCollection input = (PCollection)PBegin.in((Pipeline)this.pipeline).apply("input", (PTransform)Create.of((Object)new PersonBean("Foo", 5), (Object[])new PersonBean[]{new PersonBean("Bar", 53)}));
        String sql = "SELECT name FROM PCOLLECTION";
        PCollection result = (PCollection)input.apply("sql", (PTransform)SqlTransform.query((String)sql));
        PAssert.that((PCollection)result).containsInAnyOrder(TestUtils.rowsBuilderOf(Schema.builder().addStringField("name").build()).addRows("Foo", "Bar").getRows());
        this.pipeline.run();
    }

    @Test
    public void testJoin() {
        PCollection people = (PCollection)PBegin.in((Pipeline)this.pipeline).apply("people", (PTransform)Create.of((Object)new PersonBean("Foo", 5), (Object[])new PersonBean[]{new PersonBean("Bar", 53)}));
        PCollection orders = (PCollection)PBegin.in((Pipeline)this.pipeline).apply("orders", (PTransform)Create.of((Object)new OrderBean("Foo", 15), (Object[])new OrderBean[]{new OrderBean("Foo", 10), new OrderBean("Foo", 5), new OrderBean("Bar", 53), new OrderBean("Bar", 54), new OrderBean("Bar", 55)}));
        String sql = "SELECT name, amount FROM buyers INNER JOIN orders ON buyerName = name WHERE ageYears = 5";
        PCollection result = (PCollection)TestUtils.tuple("buyers", people, "orders", orders).apply("sql", (PTransform)SqlTransform.query((String)sql));
        PAssert.that((PCollection)result).containsInAnyOrder(TestUtils.rowsBuilderOf(Schema.builder().addStringField("name").addInt32Field("amount").build()).addRows("Foo", 15, "Foo", 10, "Foo", 5).getRows());
        this.pipeline.run();
    }

    @Test
    public void testAggregation() {
        PCollection people = (PCollection)PBegin.in((Pipeline)this.pipeline).apply("people", (PTransform)Create.of((Object)new PersonBean("Foo", 5), (Object[])new PersonBean[]{new PersonBean("Bar", 53)}));
        PCollection orders = (PCollection)PBegin.in((Pipeline)this.pipeline).apply("orders", (PTransform)Create.of((Object)new OrderBean("Foo", 15), (Object[])new OrderBean[]{new OrderBean("Foo", 10), new OrderBean("Foo", 5), new OrderBean("Bar", 53), new OrderBean("Bar", 54), new OrderBean("Bar", 55)}));
        String sql = "SELECT name, SUM(amount) as total FROM buyers INNER JOIN orders ON buyerName = name GROUP BY name";
        PCollection result = (PCollection)TestUtils.tuple("buyers", people, "orders", orders).apply("sql", (PTransform)SqlTransform.query((String)sql));
        PAssert.that((PCollection)result).containsInAnyOrder(TestUtils.rowsBuilderOf(Schema.builder().addStringField("name").addInt32Field("total").build()).addRows("Foo", 30, "Bar", 162).getRows());
        this.pipeline.run();
    }

    @DefaultSchema(value=JavaBeanSchema.class)
    public static class OrderBean
    implements Serializable {
        private Integer amount;
        private String buyerName;

        public OrderBean() {
        }

        public Integer getAmount() {
            return this.amount;
        }

        public String getBuyerName() {
            return this.buyerName;
        }

        OrderBean(String buyerName, Integer amount) {
            this.amount = amount;
            this.buyerName = buyerName;
        }

        public void setAmount(Integer amount) {
            this.amount = amount;
        }

        public void setBuyerName(String buyerName) {
            this.buyerName = buyerName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OrderBean orderBean = (OrderBean)o;
            return Objects.equals(this.amount, orderBean.amount) && Objects.equals(this.buyerName, orderBean.buyerName);
        }

        public int hashCode() {
            return Objects.hash(this.amount, this.buyerName);
        }
    }

    @DefaultSchema(value=JavaBeanSchema.class)
    public static class PersonBean
    implements Serializable {
        private Integer ageYears;
        private String name;

        public PersonBean() {
        }

        public Integer getAgeYears() {
            return this.ageYears;
        }

        public String getName() {
            return this.name;
        }

        PersonBean(String name, Integer ageYears) {
            this.ageYears = ageYears;
            this.name = name;
        }

        public void setAgeYears(Integer ageYears) {
            this.ageYears = ageYears;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PersonBean that = (PersonBean)o;
            return Objects.equals(this.ageYears, that.ageYears) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.ageYears, this.name);
        }
    }
}

