/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.ExpectedException;

public class BeamSqlDslBase {
    public static final DateTimeFormatter FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();
    @Rule
    public ExpectedException exceptions = ExpectedException.none();
    static Schema schemaInTableA;
    static List<Row> rowsInTableA;
    PCollection<Row> boundedInput1;
    PCollection<Row> boundedInput2;
    PCollection<Row> unboundedInput1;
    PCollection<Row> unboundedInput2;

    @BeforeClass
    public static void prepareClass() throws ParseException {
        schemaInTableA = Schema.builder().addInt32Field("f_int").addInt64Field("f_long").addInt16Field("f_short").addByteField("f_byte").addFloatField("f_float").addDoubleField("f_double").addStringField("f_string").addDateTimeField("f_timestamp").addInt32Field("f_int2").addDecimalField("f_decimal").build();
        rowsInTableA = TestUtils.RowsBuilder.of(schemaInTableA).addRows(1, 1000L, (short)1, (byte)1, Float.valueOf(1.0f), 1.0, "string_row1", FORMAT.parseDateTime("2017-01-01 01:01:03"), 0, new BigDecimal(1)).addRows(2, 2000L, (short)2, (byte)2, Float.valueOf(2.0f), 2.0, "string_row2", FORMAT.parseDateTime("2017-01-01 01:02:03"), 0, new BigDecimal(2)).addRows(3, 3000L, (short)3, (byte)3, Float.valueOf(3.0f), 3.0, "string_row3", FORMAT.parseDateTime("2017-01-01 01:06:03"), 0, new BigDecimal(3)).addRows(4, 4000L, (short)4, (byte)4, Float.valueOf(4.0f), 4.0, "\u7b2c\u56db\u884c", FORMAT.parseDateTime("2017-01-01 02:04:03"), 0, new BigDecimal(4)).getRows();
    }

    @Before
    public void preparePCollections() {
        this.boundedInput1 = (PCollection)this.pipeline.apply("boundedInput1", (PTransform)Create.of(rowsInTableA).withSchema(schemaInTableA, SerializableFunctions.identity(), SerializableFunctions.identity()));
        this.boundedInput2 = (PCollection)this.pipeline.apply("boundedInput2", (PTransform)Create.of((Object)rowsInTableA.get(0), (Object[])new Row[0]).withSchema(schemaInTableA, SerializableFunctions.identity(), SerializableFunctions.identity()));
        this.unboundedInput1 = this.prepareUnboundedPCollection1();
        this.unboundedInput2 = this.prepareUnboundedPCollection2();
    }

    private PCollection<Row> prepareUnboundedPCollection1() {
        TestStream.Builder values = TestStream.create((Schema)schemaInTableA, (SerializableFunction)SerializableFunctions.identity(), (SerializableFunction)SerializableFunctions.identity());
        for (Row row : rowsInTableA) {
            values = values.advanceWatermarkTo(new Instant((Object)row.getDateTime("f_timestamp")));
            values = values.addElements((Object)row, (Object[])new Row[0]);
        }
        return (PCollection)((PCollection)PBegin.in((Pipeline)this.pipeline).apply("unboundedInput1", (PTransform)values.advanceWatermarkToInfinity())).apply("unboundedInput1.fixedWindow1year", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardDays((long)365L))));
    }

    private PCollection<Row> prepareUnboundedPCollection2() {
        TestStream.Builder values = TestStream.create((Schema)schemaInTableA, (SerializableFunction)SerializableFunctions.identity(), (SerializableFunction)SerializableFunctions.identity());
        Row row = rowsInTableA.get(0);
        values = values.advanceWatermarkTo(new Instant((Object)row.getDateTime("f_timestamp")));
        values = values.addElements((Object)row, (Object[])new Row[0]);
        return (PCollection)((PCollection)PBegin.in((Pipeline)this.pipeline).apply("unboundedInput2", (PTransform)values.advanceWatermarkToInfinity())).apply("unboundedInput2.fixedWindow1year", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardDays((long)365L))));
    }
}

