/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.utils.RowAsserts;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class BeamSqlDslAggregationCovarianceTest {
    private static final double PRECISION = 1.0E-7;
    @Rule
    public TestPipeline pipeline = TestPipeline.create();
    private PCollection<Row> boundedInput;

    @Before
    public void setUp() {
        Schema schema = Schema.builder().addDoubleField("f_double1").addDoubleField("f_double2").addDoubleField("f_double3").addInt32Field("f_int1").addInt32Field("f_int2").addInt32Field("f_int3").build();
        List<Row> rowsInTableB = TestUtils.RowsBuilder.of(schema).addRows(3.0, 1.0, 1.0, 3, 1, 0, 4.0, 2.0, 2.0, 4, 2, 0, 5.0, 3.0, 1.0, 5, 3, 0, 6.0, 4.0, 2.0, 6, 4, 0, 8.0, 4.0, 1.0, 8, 4, 0).getRows();
        this.boundedInput = (PCollection)this.pipeline.apply((PTransform)Create.of(rowsInTableB).withSchema(schema, SerializableFunctions.identity(), SerializableFunctions.identity()));
    }

    @Test
    public void testPopulationVarianceDouble() {
        String sql = "SELECT COVAR_POP(f_double1, f_double2) FROM PCOLLECTION GROUP BY f_int3";
        PAssert.that((PCollection)((PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql)))).satisfies(RowAsserts.matchesScalar(1.84, 1.0E-7));
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testPopulationVarianceInt() {
        String sql = "SELECT COVAR_POP(f_int1, f_int2) FROM PCOLLECTION GROUP BY f_int3";
        PAssert.that((PCollection)((PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql)))).satisfies(RowAsserts.matchesScalar(1));
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testSampleVarianceDouble() {
        String sql = "SELECT COVAR_SAMP(f_double1, f_double2) FROM PCOLLECTION GROUP BY f_int3";
        PAssert.that((PCollection)((PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql)))).satisfies(RowAsserts.matchesScalar(2.3, 1.0E-7));
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testSampleVarianceInt() {
        String sql = "SELECT COVAR_SAMP(f_int1, f_int2) FROM PCOLLECTION GROUP BY f_int3";
        PAssert.that((PCollection)((PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql)))).satisfies(RowAsserts.matchesScalar(2));
        this.pipeline.run().waitUntilFinish();
    }
}

