/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.util.stream.Stream;
import org.apache.beam.sdk.extensions.sql.BeamSqlCli;
import org.apache.beam.sdk.extensions.sql.impl.ParseException;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.TextTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.store.InMemoryMetaStore;
import org.apache.beam.sdk.extensions.sql.meta.store.MetaStore;
import org.apache.beam.sdk.schemas.Schema;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class BeamSqlCliTest {
    @Test
    public void testExecute_createTextTable() throws Exception {
        InMemoryMetaStore metaStore = new InMemoryMetaStore();
        metaStore.registerProvider((TableProvider)new TextTableProvider());
        BeamSqlCli cli = new BeamSqlCli().metaStore((MetaStore)metaStore);
        cli.execute("create table person (\nid int COMMENT 'id', \nname varchar COMMENT 'name', \nage int COMMENT 'age') \nTYPE 'text' \nCOMMENT '' LOCATION '/home/admin/orders'");
        Table table = (Table)metaStore.getTables().get("person");
        Assert.assertNotNull((Object)table);
        Assert.assertEquals(Stream.of(Schema.Field.of((String)"id", (Schema.FieldType)CalciteUtils.INTEGER).withDescription("id").withNullable(true), Schema.Field.of((String)"name", (Schema.FieldType)CalciteUtils.VARCHAR).withDescription("name").withNullable(true), Schema.Field.of((String)"age", (Schema.FieldType)CalciteUtils.INTEGER).withDescription("age").withNullable(true)).collect(Schema.toSchema()), (Object)table.getSchema());
    }

    @Test
    public void testExecute_createTableWithPrefixArrayField() throws Exception {
        InMemoryMetaStore metaStore = new InMemoryMetaStore();
        metaStore.registerProvider((TableProvider)new TextTableProvider());
        BeamSqlCli cli = new BeamSqlCli().metaStore((MetaStore)metaStore);
        cli.execute("create table person (\nid int COMMENT 'id', \nname varchar COMMENT 'name', \nage int COMMENT 'age', \ntags ARRAY<VARCHAR>, \nmatrix ARRAY<ARRAY<INTEGER>> \n) \nTYPE 'text' \nCOMMENT '' LOCATION '/home/admin/orders'");
        Table table = (Table)metaStore.getTables().get("person");
        Assert.assertNotNull((Object)table);
        Assert.assertEquals(Stream.of(Schema.Field.of((String)"id", (Schema.FieldType)CalciteUtils.INTEGER).withDescription("id").withNullable(true), Schema.Field.of((String)"name", (Schema.FieldType)CalciteUtils.VARCHAR).withDescription("name").withNullable(true), Schema.Field.of((String)"age", (Schema.FieldType)CalciteUtils.INTEGER).withDescription("age").withNullable(true), Schema.Field.of((String)"tags", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)CalciteUtils.VARCHAR)).withNullable(true), Schema.Field.of((String)"matrix", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.array((Schema.FieldType)CalciteUtils.INTEGER))).withNullable(true)).collect(Schema.toSchema()), (Object)table.getSchema());
    }

    @Test
    public void testExecute_createTableWithPrefixMapField() throws Exception {
        InMemoryMetaStore metaStore = new InMemoryMetaStore();
        metaStore.registerProvider((TableProvider)new TextTableProvider());
        BeamSqlCli cli = new BeamSqlCli().metaStore((MetaStore)metaStore);
        cli.execute("create table person (\nid int COMMENT 'id', \nname varchar COMMENT 'name', \nage int COMMENT 'age', \ntags MAP<VARCHAR, VARCHAR>, \nnestedMap MAP<INTEGER, MAP<VARCHAR, INTEGER>> \n) \nTYPE 'text' \nCOMMENT '' LOCATION '/home/admin/orders'");
        Table table = (Table)metaStore.getTables().get("person");
        Assert.assertNotNull((Object)table);
        Assert.assertEquals(Stream.of(Schema.Field.of((String)"id", (Schema.FieldType)CalciteUtils.INTEGER).withDescription("id").withNullable(true), Schema.Field.of((String)"name", (Schema.FieldType)CalciteUtils.VARCHAR).withDescription("name").withNullable(true), Schema.Field.of((String)"age", (Schema.FieldType)CalciteUtils.INTEGER).withDescription("age").withNullable(true), Schema.Field.of((String)"tags", (Schema.FieldType)Schema.FieldType.map((Schema.FieldType)CalciteUtils.VARCHAR, (Schema.FieldType)CalciteUtils.VARCHAR)).withNullable(true), Schema.Field.of((String)"nestedMap", (Schema.FieldType)Schema.FieldType.map((Schema.FieldType)CalciteUtils.INTEGER, (Schema.FieldType)Schema.FieldType.map((Schema.FieldType)CalciteUtils.VARCHAR, (Schema.FieldType)CalciteUtils.INTEGER))).withNullable(true)).collect(Schema.toSchema()), (Object)table.getSchema());
    }

    @Test
    public void testExecute_createTableWithRowField() throws Exception {
        InMemoryMetaStore metaStore = new InMemoryMetaStore();
        metaStore.registerProvider((TableProvider)new TextTableProvider());
        BeamSqlCli cli = new BeamSqlCli().metaStore((MetaStore)metaStore);
        cli.execute("create table person (\nid int COMMENT 'id', \nname varchar COMMENT 'name', \nage int COMMENT 'age', \naddress ROW ( \n  street VARCHAR, \n  country VARCHAR \n  ), \naddressAngular ROW< \n  street VARCHAR, \n  country VARCHAR \n  >, \nisRobot BOOLEAN) \nTYPE 'text' \nCOMMENT '' LOCATION '/home/admin/orders'");
        Table table = (Table)metaStore.getTables().get("person");
        Assert.assertNotNull((Object)table);
        Assert.assertEquals(Stream.of(Schema.Field.of((String)"id", (Schema.FieldType)CalciteUtils.INTEGER).withDescription("id").withNullable(true), Schema.Field.of((String)"name", (Schema.FieldType)CalciteUtils.VARCHAR).withDescription("name").withNullable(true), Schema.Field.of((String)"age", (Schema.FieldType)CalciteUtils.INTEGER).withDescription("age").withNullable(true), Schema.Field.of((String)"address", (Schema.FieldType)Schema.FieldType.row((Schema)Schema.builder().addNullableField("street", Schema.FieldType.STRING).addNullableField("country", Schema.FieldType.STRING).build())).withNullable(true), Schema.Field.of((String)"addressAngular", (Schema.FieldType)Schema.FieldType.row((Schema)Schema.builder().addNullableField("street", Schema.FieldType.STRING).addNullableField("country", Schema.FieldType.STRING).build())).withNullable(true), Schema.Field.of((String)"isRobot", (Schema.FieldType)CalciteUtils.BOOLEAN).withNullable(true)).collect(Schema.toSchema()), (Object)table.getSchema());
    }

    @Test
    public void testExecute_dropTable() throws Exception {
        InMemoryMetaStore metaStore = new InMemoryMetaStore();
        metaStore.registerProvider((TableProvider)new TextTableProvider());
        BeamSqlCli cli = new BeamSqlCli().metaStore((MetaStore)metaStore);
        cli.execute("create table person (\nid int COMMENT 'id', \nname varchar COMMENT 'name', \nage int COMMENT 'age') \nTYPE 'text' \nCOMMENT '' LOCATION '/home/admin/orders'");
        Table table = (Table)metaStore.getTables().get("person");
        Assert.assertNotNull((Object)table);
        cli.execute("drop table person");
        table = (Table)metaStore.getTables().get("person");
        Assert.assertNull((Object)table);
    }

    @Test(expected=ParseException.class)
    public void testExecute_dropTable_assertTableRemovedFromPlanner() throws Exception {
        InMemoryMetaStore metaStore = new InMemoryMetaStore();
        metaStore.registerProvider((TableProvider)new TextTableProvider());
        BeamSqlCli cli = new BeamSqlCli().metaStore((MetaStore)metaStore);
        cli.execute("create table person (\nid int COMMENT 'id', \nname varchar COMMENT 'name', \nage int COMMENT 'age') \nTYPE 'text' \nCOMMENT '' LOCATION '/home/admin/orders'");
        cli.execute("drop table person");
        cli.explainQuery("select * from person");
    }

    @Test
    public void testExplainQuery() throws Exception {
        InMemoryMetaStore metaStore = new InMemoryMetaStore();
        metaStore.registerProvider((TableProvider)new TextTableProvider());
        BeamSqlCli cli = new BeamSqlCli().metaStore((MetaStore)metaStore);
        cli.execute("create table person (\nid int COMMENT 'id', \nname varchar COMMENT 'name', \nage int COMMENT 'age') \nTYPE 'text' \nCOMMENT '' LOCATION '/home/admin/orders'");
        String plan = cli.explainQuery("select * from person");
        Assert.assertThat((Object)plan, (Matcher)Matchers.equalTo((Object)"BeamCalcRel(expr#0..2=[{inputs}], proj#0..2=[{exprs}])\n  BeamIOSourceRel(table=[[beam, person]])\n"));
    }
}

