/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMap;

public class CompositeMap<K, V>
implements Map<K, V> {
    private final ImmutableList<Map<K, V>> maps;

    public CompositeMap(ImmutableList<Map<K, V>> maps) {
        this.maps = maps;
    }

    public static <K, V> CompositeMap<K, V> of(Map<K, V> map0, Map<K, V> ... maps) {
        return new CompositeMap<K, V>(CompositeMap.list(map0, maps));
    }

    private static <E> ImmutableList<E> list(E e, E[] es) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)e);
        for (E map : es) {
            builder.add((Object)map);
        }
        return builder.build();
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        for (Map map : this.maps) {
            if (map.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        for (Map map : this.maps) {
            if (!map.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map map : this.maps) {
            if (!map.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        for (Map map : this.maps) {
            if (!map.containsKey(key)) continue;
            return map.get(key);
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        LinkedHashSet keys = new LinkedHashSet();
        for (Map map : this.maps) {
            keys.addAll(map.keySet());
        }
        return keys;
    }

    private Map<K, V> combinedMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        LinkedHashSet keys = new LinkedHashSet();
        for (Map map : this.maps) {
            for (Map.Entry entry : map.entrySet()) {
                if (!keys.add(entry.getKey())) continue;
                builder.put(entry);
            }
        }
        return builder.build();
    }

    @Override
    public Collection<V> values() {
        return this.combinedMap().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.combinedMap().entrySet();
    }
}

