/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.pubsublite;

import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.meta.SchemaBaseBeamTable;
import org.apache.beam.sdk.io.gcp.pubsublite.PubsubLiteIO;
import org.apache.beam.sdk.io.gcp.pubsublite.SubscriberOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class PubsubLiteSubscriptionTable
extends SchemaBaseBeamTable {
    private final @UnknownKeyFor @NonNull @Initialized SubscriptionPath subscription;
    private final @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized SequencedMessage>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> transform;

    PubsubLiteSubscriptionTable(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized SubscriptionPath subscription, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized SequencedMessage>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> transform) {
        super(schema);
        this.subscription = subscription;
        this.transform = transform;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> buildIOReader(@UnknownKeyFor @NonNull @Initialized PBegin begin) {
        return (PCollection)((PCollection)begin.apply("Read Pub/Sub Lite", PubsubLiteIO.read((SubscriberOptions)SubscriberOptions.newBuilder().setSubscriptionPath(this.subscription).build()))).apply("Transform to Row", this.transform);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized POutput buildIOWriter(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
        throw new UnsupportedOperationException("You cannot write to a Pub/Sub Lite subscription: you must write to a topic.");
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.UNBOUNDED;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamTableStatistics getTableStatistics(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return BeamTableStatistics.UNBOUNDED_UNKNOWN;
    }
}

