/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider;

import java.util.Map;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ReadOnlyTableProvider
implements TableProvider {
    private final @UnknownKeyFor @NonNull @Initialized String typeName;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BeamSqlTable> tables;

    public ReadOnlyTableProvider(@UnknownKeyFor @NonNull @Initialized String typeName, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BeamSqlTable> tables) {
        this.typeName = typeName;
        this.tables = tables;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTableType() {
        return this.typeName;
    }

    @Override
    public void createTable(@UnknownKeyFor @NonNull @Initialized Table table) {
        throw new UnsupportedOperationException("ReadOnlyTableProvider does not support table creation");
    }

    @Override
    public void dropTable(@UnknownKeyFor @NonNull @Initialized String tableName) {
        throw new UnsupportedOperationException("ReadOnlyTableProvider does not support table deletion");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Table> getTables() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry<String, BeamSqlTable> table : this.tables.entrySet()) {
            map.put((Object)table.getKey(), (Object)Table.builder().type(this.getTableType()).name(table.getKey()).schema(Schema.builder().build()).build());
        }
        return map.build();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamSqlTable buildBeamSqlTable(@UnknownKeyFor @NonNull @Initialized Table table) {
        return this.tables.get(table.getName());
    }
}

