/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.planner;

import com.google.auto.value.AutoValue;
import org.apache.beam.sdk.extensions.sql.impl.planner.AutoValue_NodeStats;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
public abstract class NodeStats {
    public static final @UnknownKeyFor @NonNull @Initialized NodeStats UNKNOWN = NodeStats.create(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    public abstract @UnknownKeyFor @NonNull @Initialized double getRowCount();

    public abstract @UnknownKeyFor @NonNull @Initialized double getRate();

    public abstract @UnknownKeyFor @NonNull @Initialized double getWindow();

    public static @UnknownKeyFor @NonNull @Initialized NodeStats create(@UnknownKeyFor @NonNull @Initialized double rowCount, @UnknownKeyFor @NonNull @Initialized double rate, @UnknownKeyFor @NonNull @Initialized double window) {
        if (window < 0.0 || rate < 0.0 || rowCount < 0.0) {
            throw new IllegalArgumentException("All the estimates in NodeStats should be positive");
        }
        return new AutoValue_NodeStats(rowCount, rate, window);
    }

    public static @UnknownKeyFor @NonNull @Initialized NodeStats create(@UnknownKeyFor @NonNull @Initialized double rowCount) {
        return NodeStats.create(rowCount, 0.0, rowCount);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isUnknown() {
        return Double.isInfinite(this.getRowCount()) || Double.isInfinite(this.getRate()) || Double.isInfinite(this.getWindow());
    }

    public @UnknownKeyFor @NonNull @Initialized NodeStats multiply(@UnknownKeyFor @NonNull @Initialized double factor) {
        return NodeStats.create(this.getRowCount() * factor, this.getRate() * factor, this.getWindow() * factor);
    }

    public @UnknownKeyFor @NonNull @Initialized NodeStats plus(@UnknownKeyFor @NonNull @Initialized NodeStats that) {
        if (this.isUnknown() || that.isUnknown()) {
            return UNKNOWN;
        }
        return NodeStats.create(this.getRowCount() + that.getRowCount(), this.getRate() + that.getRate(), this.getWindow() + that.getWindow());
    }

    public @UnknownKeyFor @NonNull @Initialized NodeStats minus(@UnknownKeyFor @NonNull @Initialized NodeStats that) {
        if (this.isUnknown() || that.isUnknown()) {
            return UNKNOWN;
        }
        return NodeStats.create(Math.max(this.getRowCount() - that.getRowCount(), 0.0), Math.max(this.getRate() - that.getRate(), 0.0), Math.max(this.getWindow() - that.getWindow(), 0.0));
    }
}

