/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import com.google.auto.value.AutoValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.ProviderNotFoundException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.beam.sdk.extensions.sql.impl.AutoValue_JavaUdfLoader_FunctionDefinitions;
import org.apache.beam.sdk.extensions.sql.udf.AggregateFn;
import org.apache.beam.sdk.extensions.sql.udf.ScalarFn;
import org.apache.beam.sdk.extensions.sql.udf.UdfProvider;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.commons.codec.digest.DigestUtils;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteStreams;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaUdfLoader {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(JavaUdfLoader.class);
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FunctionDefinitions> functionCache = new HashMap<String, FunctionDefinitions>();
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized File> jarCache = new HashMap<String, File>();

    public @UnknownKeyFor @NonNull @Initialized ScalarFn loadScalarFunction(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> functionPath, @UnknownKeyFor @NonNull @Initialized String jarPath) {
        String functionFullName = String.join((CharSequence)".", functionPath);
        try {
            FunctionDefinitions functionDefinitions = this.loadJar(jarPath);
            if (!functionDefinitions.scalarFunctions().containsKey(functionPath)) {
                throw new IllegalArgumentException(String.format("No implementation of scalar function %s found in %s.%n 1. Create a class implementing %s and annotate it with @AutoService(%s.class).%n 2. Add function %s to the class's userDefinedScalarFunctions implementation.", functionFullName, jarPath, UdfProvider.class.getSimpleName(), UdfProvider.class.getSimpleName(), functionFullName));
            }
            return (ScalarFn)functionDefinitions.scalarFunctions().get(functionPath);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to load user-defined scalar function %s from %s", functionFullName, jarPath), e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized AggregateFn loadAggregateFunction(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> functionPath, @UnknownKeyFor @NonNull @Initialized String jarPath) {
        String functionFullName = String.join((CharSequence)".", functionPath);
        try {
            FunctionDefinitions functionDefinitions = this.loadJar(jarPath);
            if (!functionDefinitions.aggregateFunctions().containsKey(functionPath)) {
                throw new IllegalArgumentException(String.format("No implementation of aggregate function %s found in %s.%n 1. Create a class implementing %s and annotate it with @AutoService(%s.class).%n 2. Add function %s to the class's userDefinedAggregateFunctions implementation.", functionFullName, jarPath, UdfProvider.class.getSimpleName(), UdfProvider.class.getSimpleName(), functionFullName));
            }
            return (AggregateFn)functionDefinitions.aggregateFunctions().get(functionPath);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to load user-defined aggregate function %s from %s", functionFullName, jarPath), e);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized File downloadFile(@UnknownKeyFor @NonNull @Initialized String inputPath, @UnknownKeyFor @NonNull @Initialized String mimeType) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkArgument((!inputPath.isEmpty() ? 1 : 0) != 0, (Object)"Path cannot be empty.");
        ResourceId inputResource = FileSystems.matchNewResource((String)inputPath, (boolean)false);
        try (ReadableByteChannel inputChannel = FileSystems.open((ResourceId)inputResource);){
            File outputFile = File.createTempFile("sql-udf-", inputResource.getFilename());
            ResourceId outputResource = FileSystems.matchNewResource((String)outputFile.getAbsolutePath(), (boolean)false);
            try (WritableByteChannel outputChannel = FileSystems.create((ResourceId)outputResource, (String)mimeType);){
                ByteStreams.copy((ReadableByteChannel)inputChannel, (WritableByteChannel)outputChannel);
            }
            var9_10 = null;
            try (FileInputStream inputStream = new FileInputStream(outputFile);){
                LOG.info("Copied {} to {} with md5 hash {}.", new Object[]{inputPath, outputFile.getAbsolutePath(), DigestUtils.md5Hex((InputStream)inputStream)});
            }
            catch (Throwable throwable) {
                var9_10 = throwable;
                throw throwable;
            }
            File file = outputFile;
            return file;
        }
    }

    private @UnknownKeyFor @NonNull @Initialized File getLocalJar(@UnknownKeyFor @NonNull @Initialized String inputJarPath) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (!jarCache.containsKey(inputJarPath)) {
            jarCache.put(inputJarPath, this.downloadFile(inputJarPath, "application/java-archive"));
        }
        return jarCache.get(inputJarPath);
    }

    private @UnknownKeyFor @NonNull @Initialized URLClassLoader createUrlClassLoader(final @UnknownKeyFor @NonNull @Initialized URL @UnknownKeyFor @NonNull @Initialized [] urls) {
        return AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized URLClassLoader run() {
                return new URLClassLoader(urls);
            }
        });
    }

    private @UnknownKeyFor @NonNull @Initialized ClassLoader createClassLoader(@UnknownKeyFor @NonNull @Initialized String inputJarPath) throws @UnknownKeyFor @NonNull @Initialized IOException {
        File tmpJar = this.getLocalJar(inputJarPath);
        URL url = tmpJar.toURI().toURL();
        return this.createUrlClassLoader(new URL[]{url});
    }

    public @UnknownKeyFor @NonNull @Initialized ClassLoader createClassLoader(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputJarPaths) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String inputJar : inputJarPaths) {
            urls.add(this.getLocalJar(inputJar).toURI().toURL());
        }
        return this.createUrlClassLoader(urls.toArray(new URL[0]));
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized UdfProvider> getUdfProviders(@UnknownKeyFor @NonNull @Initialized ClassLoader classLoader) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return ServiceLoader.load(UdfProvider.class, classLoader).iterator();
    }

    private @UnknownKeyFor @NonNull @Initialized FunctionDefinitions loadJar(@UnknownKeyFor @NonNull @Initialized String jarPath) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (functionCache.containsKey(jarPath)) {
            LOG.debug("Using cached function definitions from {}", (Object)jarPath);
            return functionCache.get(jarPath);
        }
        ClassLoader classLoader = this.createClassLoader(jarPath);
        HashMap scalarFunctions = new HashMap();
        HashMap aggregateFunctions = new HashMap();
        Iterator<UdfProvider> providers = this.getUdfProviders(classLoader);
        int providersCount = 0;
        while (providers.hasNext()) {
            ++providersCount;
            UdfProvider provider = providers.next();
            provider.userDefinedScalarFunctions().forEach((functionName, implementation) -> {
                ImmutableList functionPath = ImmutableList.copyOf((Object[])functionName.split("\\."));
                if (scalarFunctions.containsKey(functionPath)) {
                    throw new IllegalArgumentException(String.format("Found multiple definitions of scalar function %s in %s.", functionName, jarPath));
                }
                scalarFunctions.put(functionPath, implementation);
            });
            provider.userDefinedAggregateFunctions().forEach((functionName, implementation) -> {
                ImmutableList functionPath = ImmutableList.copyOf((Object[])functionName.split("\\."));
                if (aggregateFunctions.containsKey(functionPath)) {
                    throw new IllegalArgumentException(String.format("Found multiple definitions of aggregate function %s in %s.", functionName, jarPath));
                }
                aggregateFunctions.put(functionPath, implementation);
            });
        }
        if (providersCount == 0) {
            throw new ProviderNotFoundException(String.format("No %s implementation found in %s. Create a class implementing %s and annotate it with @AutoService(%s.class).", UdfProvider.class.getSimpleName(), jarPath, UdfProvider.class.getSimpleName(), UdfProvider.class.getSimpleName()));
        }
        LOG.info("Loaded {} implementations of {} from {} with {} scalar function(s).", new Object[]{providersCount, UdfProvider.class.getSimpleName(), jarPath, scalarFunctions.size()});
        FunctionDefinitions userFunctionDefinitions = FunctionDefinitions.newBuilder().setScalarFunctions((ImmutableMap<List<String>, ScalarFn>)ImmutableMap.copyOf(scalarFunctions)).setAggregateFunctions((ImmutableMap<List<String>, AggregateFn>)ImmutableMap.copyOf(aggregateFunctions)).build();
        functionCache.put(jarPath, userFunctionDefinitions);
        return userFunctionDefinitions;
    }

    @AutoValue
    static abstract class FunctionDefinitions {
        FunctionDefinitions() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @NonNull @Initialized ScalarFn> scalarFunctions();

        abstract @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @NonNull @Initialized AggregateFn> aggregateFunctions();

        static @UnknownKeyFor @NonNull @Initialized Builder newBuilder() {
            return new AutoValue_JavaUdfLoader_FunctionDefinitions.Builder().setScalarFunctions((ImmutableMap<List<String>, ScalarFn>)ImmutableMap.of()).setAggregateFunctions((ImmutableMap<List<String>, AggregateFn>)ImmutableMap.of());
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setScalarFunctions(@UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @NonNull @Initialized ScalarFn> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setAggregateFunctions(@UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @NonNull @Initialized AggregateFn> var1);

            abstract @UnknownKeyFor @NonNull @Initialized FunctionDefinitions build();
        }
    }
}

