/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.seqgen;

import java.io.Serializable;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.meta.SchemaBaseBeamTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.joda.time.Duration;
import org.joda.time.Instant;

class GenerateSequenceTable
extends SchemaBaseBeamTable
implements Serializable {
    public static final Schema TABLE_SCHEMA = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"sequence", (Schema.FieldType)Schema.FieldType.INT64), Schema.Field.of((String)"event_time", (Schema.FieldType)Schema.FieldType.DATETIME)});
    Integer elementsPerSecond = 5;

    GenerateSequenceTable(Table table) {
        super(TABLE_SCHEMA);
        if (table.getProperties().containsKey((Object)"elementsPerSecond")) {
            this.elementsPerSecond = table.getProperties().getInteger("elementsPerSecond");
        }
    }

    @Override
    public PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.UNBOUNDED;
    }

    @Override
    public PCollection<Row> buildIOReader(PBegin begin) {
        return ((PCollection)((PCollection)begin.apply((PTransform)GenerateSequence.from((long)0L).withRate((long)this.elementsPerSecond.intValue(), Duration.standardSeconds((long)1L)))).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(Row.class)).via((SerializableFunction & Serializable)elm -> Row.withSchema((Schema)TABLE_SCHEMA).addValues(new Object[]{elm, Instant.now()}).build()))).setRowSchema(this.getSchema());
    }

    @Override
    public BeamTableStatistics getTableStatistics(PipelineOptions options) {
        return BeamTableStatistics.createUnboundedTableStatistics((double)this.elementsPerSecond);
    }

    @Override
    public POutput buildIOWriter(PCollection<Row> input) {
        throw new UnsupportedOperationException("buildIOWriter unsupported!");
    }
}

