/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.store;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.TextTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.store.InMemoryMetaStore;
import org.apache.beam.sdk.schemas.Schema;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InMemoryMetaStoreTest {
    private InMemoryMetaStore store;

    @Before
    public void setUp() {
        this.store = new InMemoryMetaStore();
        this.store.registerProvider((TableProvider)new TextTableProvider());
    }

    @Test
    public void testCreateTable() throws Exception {
        Table table = InMemoryMetaStoreTest.mockTable("person");
        this.store.createTable(table);
        Table actualTable = (Table)this.store.getTables().get("person");
        Assert.assertEquals((Object)table, (Object)actualTable);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateTable_invalidTableType() throws Exception {
        Table table = InMemoryMetaStoreTest.mockTable("person", "invalid");
        this.store.createTable(table);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateTable_duplicatedName() throws Exception {
        Table table = InMemoryMetaStoreTest.mockTable("person");
        this.store.createTable(table);
        this.store.createTable(table);
    }

    @Test
    public void testGetTables() throws Exception {
        this.store.createTable(InMemoryMetaStoreTest.mockTable("hello"));
        this.store.createTable(InMemoryMetaStoreTest.mockTable("world"));
        Assert.assertEquals((long)2L, (long)this.store.getTables().size());
        MatcherAssert.assertThat((Object)this.store.getTables(), (Matcher)Matchers.hasValue((Object)InMemoryMetaStoreTest.mockTable("hello")));
        MatcherAssert.assertThat((Object)this.store.getTables(), (Matcher)Matchers.hasValue((Object)InMemoryMetaStoreTest.mockTable("world")));
    }

    @Test
    public void testBuildBeamSqlTable() throws Exception {
        Table table = InMemoryMetaStoreTest.mockTable("hello");
        this.store.createTable(table);
        BeamSqlTable actualSqlTable = this.store.buildBeamSqlTable(table);
        Assert.assertNotNull((Object)actualSqlTable);
        Assert.assertEquals((Object)Schema.builder().addNullableField("id", Schema.FieldType.INT32).addNullableField("name", Schema.FieldType.STRING).build(), (Object)actualSqlTable.getSchema());
    }

    @Test
    public void testRegisterProvider() throws Exception {
        this.store.registerProvider((TableProvider)new MockTableProvider("mock", "hello", "world"));
        Assert.assertNotNull((Object)this.store.getProviders());
        Assert.assertEquals((long)2L, (long)this.store.getProviders().size());
        Assert.assertEquals((Object)"text", (Object)((TableProvider)this.store.getProviders().get("text")).getTableType());
        Assert.assertEquals((Object)"mock", (Object)((TableProvider)this.store.getProviders().get("mock")).getTableType());
        Assert.assertEquals((long)2L, (long)this.store.getTables().size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterProvider_duplicatedTableType() throws Exception {
        this.store.registerProvider((TableProvider)new MockTableProvider("mock", new String[0]));
        this.store.registerProvider((TableProvider)new MockTableProvider("mock", new String[0]));
    }

    @Test(expected=IllegalStateException.class)
    public void testRegisterProvider_duplicatedTableName() throws Exception {
        this.store.registerProvider((TableProvider)new MockTableProvider("mock", "hello", "world"));
        this.store.registerProvider((TableProvider)new MockTableProvider("mock1", "hello", "world"));
    }

    private static Table mockTable(String name, String type) {
        return Table.builder().name(name).comment(name + " table").location("/home/admin/" + name).schema((Schema)Stream.of(Schema.Field.nullable((String)"id", (Schema.FieldType)Schema.FieldType.INT32), Schema.Field.nullable((String)"name", (Schema.FieldType)Schema.FieldType.STRING)).collect(Schema.toSchema())).type(type).properties(new JSONObject()).build();
    }

    private static Table mockTable(String name) {
        return InMemoryMetaStoreTest.mockTable(name, "text");
    }

    private static class MockTableProvider
    implements TableProvider {
        private String type;
        private String[] names;

        public MockTableProvider(String type, String ... names) {
            this.type = type;
            this.names = names;
        }

        public String getTableType() {
            return this.type;
        }

        public void createTable(Table table) {
        }

        public void dropTable(String tableName) {
        }

        public Map<String, Table> getTables() {
            HashMap<String, Table> ret = new HashMap<String, Table>(this.names.length);
            for (String name : this.names) {
                ret.put(name, InMemoryMetaStoreTest.mockTable(name, "mock"));
            }
            return ret;
        }

        public BeamSqlTable buildBeamSqlTable(Table table) {
            return null;
        }
    }
}

