/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.text;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.NumberedShardedFile;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.base.Charsets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TextTableProviderTest {
    @Rule
    public TestPipeline pipeline = TestPipeline.create();
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder(){

        protected void after() {
        }
    };
    private static final String SQL_CSV_SCHEMA = "(f_string VARCHAR, f_int INT)";
    private static final Schema CSV_SCHEMA = Schema.builder().addNullableField("f_string", Schema.FieldType.STRING).addNullableField("f_int", Schema.FieldType.INT32).build();
    private static final Schema LINES_SCHEMA = Schema.builder().addStringField("f_string").build();
    private static final String SQL_LINES_SCHEMA = "(f_string VARCHAR)";
    private static final Schema JSON_SCHEMA = Schema.builder().addStringField("name").addInt32Field("age").build();
    private static final String SQL_JSON_SCHEMA = "(name VARCHAR, age INTEGER)";
    private static final String JSON_TEXT = "{\"name\":\"Jack\",\"age\":13}";
    private static final String INVALID_JSON_TEXT = "{\"name\":\"Jack\",\"age\":\"thirteen\"}";
    private static final Schema SINGLE_STRING_CSV_SCHEMA = Schema.builder().addStringField("f_string").build();
    private static final String SINGLE_STRING_SQL_SCHEMA = "(f_string VARCHAR)";

    @Test
    public void testLegacyDefaultCsv() throws Exception {
        Files.write(this.tempFolder.newFile("test.csv").toPath(), "hello,13\n\ngoodbye,42\n".getBytes(Charsets.UTF_8), new OpenOption[0]);
        String query = "SELECT * FROM test";
        String ddl = String.format("CREATE EXTERNAL TABLE test %s TYPE text LOCATION '%s/*'", SQL_CSV_SCHEMA, this.tempFolder.getRoot());
        PCollection rows = (PCollection)this.pipeline.apply((PTransform)SqlTransform.query((String)query).withDdlString(ddl));
        PAssert.that((PCollection)rows).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)CSV_SCHEMA).addValues(new Object[]{"hello", 13}).build(), Row.withSchema((Schema)CSV_SCHEMA).addValues(new Object[]{"goodbye", 42}).build()});
        this.pipeline.run();
    }

    @Test
    public void testLegacyTdfCsv() throws Exception {
        Files.write(this.tempFolder.newFile("test.csv").toPath(), "hello\t13\n\ngoodbye\t42\n".getBytes(Charsets.UTF_8), new OpenOption[0]);
        String query = "SELECT * FROM test";
        String ddl = String.format("CREATE EXTERNAL TABLE test %s TYPE text LOCATION '%s/*' TBLPROPERTIES '{\"format\":\"TDF\"}'", SQL_CSV_SCHEMA, this.tempFolder.getRoot());
        PCollection rows = (PCollection)this.pipeline.apply((PTransform)SqlTransform.query((String)query).withDdlString(ddl));
        rows.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.voids()).via((SerializableFunction & Serializable)r -> {
            System.out.println(r.toString());
            return null;
        }));
        PAssert.that((PCollection)rows).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)CSV_SCHEMA).addValues(new Object[]{"hello", 13}).build(), Row.withSchema((Schema)CSV_SCHEMA).addValues(new Object[]{"goodbye", 42}).build()});
        this.pipeline.run();
    }

    @Test
    public void testExplicitCsv() throws Exception {
        Files.write(this.tempFolder.newFile("test.csv").toPath(), "hello,13\n\ngoodbye,42\n".getBytes(Charsets.UTF_8), new OpenOption[0]);
        String query = "SELECT * FROM test";
        String ddl = String.format("CREATE EXTERNAL TABLE test %s TYPE text LOCATION '%s/*' TBLPROPERTIES '{\"format\":\"csv\"}'", SQL_CSV_SCHEMA, this.tempFolder.getRoot());
        PCollection rows = (PCollection)this.pipeline.apply((PTransform)SqlTransform.query((String)query).withDdlString(ddl));
        PAssert.that((PCollection)rows).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)CSV_SCHEMA).addValues(new Object[]{"hello", 13}).build(), Row.withSchema((Schema)CSV_SCHEMA).addValues(new Object[]{"goodbye", 42}).build()});
        this.pipeline.run();
    }

    @Test
    public void testExplicitCsvExcel() throws Exception {
        Files.write(this.tempFolder.newFile("test.csv").toPath(), "hello\n\ngoodbye\n".getBytes(Charsets.UTF_8), new OpenOption[0]);
        String query = "SELECT * FROM test";
        String ddl = String.format("CREATE EXTERNAL TABLE test %s TYPE text LOCATION '%s/*' TBLPROPERTIES '{\"format\":\"csv\", \"csvFormat\":\"Excel\"}'", "(f_string VARCHAR)", this.tempFolder.getRoot());
        PCollection rows = (PCollection)this.pipeline.apply((PTransform)SqlTransform.query((String)query).withDdlString(ddl));
        PAssert.that((PCollection)rows).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)SINGLE_STRING_CSV_SCHEMA).addValues(new Object[]{"hello"}).build(), Row.withSchema((Schema)SINGLE_STRING_CSV_SCHEMA).addValues(new Object[]{"goodbye"}).build()});
        this.pipeline.run();
    }

    @Test
    public void testLines() throws Exception {
        Files.write(this.tempFolder.newFile("test.csv").toPath(), "hello,13\ngoodbye,42\n".getBytes(Charsets.UTF_8), new OpenOption[0]);
        String query = "SELECT * FROM test";
        String ddl = String.format("CREATE EXTERNAL TABLE test %s TYPE text LOCATION '%s/*' TBLPROPERTIES '{\"format\":\"lines\"}'", "(f_string VARCHAR)", this.tempFolder.getRoot());
        PCollection rows = (PCollection)this.pipeline.apply((PTransform)SqlTransform.query((String)query).withDdlString(ddl));
        PAssert.that((PCollection)rows).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)LINES_SCHEMA).addValues(new Object[]{"hello,13"}).build(), Row.withSchema((Schema)LINES_SCHEMA).addValues(new Object[]{"goodbye,42"}).build()});
        this.pipeline.run();
    }

    @Test
    public void testJson() throws Exception {
        Files.write(this.tempFolder.newFile("test.json").toPath(), JSON_TEXT.getBytes(Charsets.UTF_8), new OpenOption[0]);
        String query = "SELECT * FROM test";
        String ddl = String.format("CREATE EXTERNAL TABLE test %s TYPE text LOCATION '%s/*' TBLPROPERTIES '{\"format\":\"json\"}'", SQL_JSON_SCHEMA, this.tempFolder.getRoot());
        PCollection rows = (PCollection)this.pipeline.apply((PTransform)SqlTransform.query((String)query).withDdlString(ddl));
        PAssert.that((PCollection)rows).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)JSON_SCHEMA).addValues(new Object[]{"Jack", 13}).build()});
        this.pipeline.run();
    }

    @Test
    public void testInvalidJson() throws Exception {
        File deadLetterFile = new File(this.tempFolder.getRoot(), "dead-letter-file");
        Files.write(this.tempFolder.newFile("test.json").toPath(), INVALID_JSON_TEXT.getBytes(Charsets.UTF_8), new OpenOption[0]);
        String query = "SELECT * FROM test";
        String ddl = String.format("CREATE EXTERNAL TABLE test %s TYPE text LOCATION '%s/*' TBLPROPERTIES '{\"format\":\"json\", \"deadLetterFile\": \"%s\"}'", SQL_JSON_SCHEMA, this.tempFolder.getRoot(), deadLetterFile.getAbsoluteFile());
        PCollection rows = (PCollection)this.pipeline.apply((PTransform)SqlTransform.query((String)query).withDdlString(ddl));
        PAssert.that((PCollection)rows).empty();
        this.pipeline.run();
        MatcherAssert.assertThat((Object)new NumberedShardedFile(deadLetterFile.getAbsoluteFile() + "*").readFilesWithRetries(Sleeper.DEFAULT, BackOff.STOP_BACKOFF), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{INVALID_JSON_TEXT}));
    }

    @Test
    public void testWriteLines() throws Exception {
        File destinationFile = new File(this.tempFolder.getRoot(), "lines-outputs");
        String query = "INSERT INTO test VALUES ('hello'), ('goodbye')";
        String ddl = String.format("CREATE EXTERNAL TABLE test %s TYPE text LOCATION '%s' TBLPROPERTIES '{\"format\":\"lines\"}'", "(f_string VARCHAR)", destinationFile.getAbsolutePath());
        this.pipeline.apply((PTransform)SqlTransform.query((String)query).withDdlString(ddl));
        this.pipeline.run();
        MatcherAssert.assertThat((Object)new NumberedShardedFile(destinationFile.getAbsolutePath() + "*").readFilesWithRetries(Sleeper.DEFAULT, BackOff.STOP_BACKOFF), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"hello", "goodbye"}));
    }

    @Test
    public void testWriteCsv() throws Exception {
        File destinationFile = new File(this.tempFolder.getRoot(), "csv-outputs");
        String query = "INSERT INTO test VALUES ('hello', 42), ('goodbye', 13)";
        String ddl = String.format("CREATE EXTERNAL TABLE test %s TYPE text LOCATION '%s' TBLPROPERTIES '{\"format\":\"csv\"}'", SQL_CSV_SCHEMA, destinationFile.getAbsolutePath());
        this.pipeline.apply((PTransform)SqlTransform.query((String)query).withDdlString(ddl));
        this.pipeline.run();
        MatcherAssert.assertThat((Object)new NumberedShardedFile(destinationFile.getAbsolutePath() + "*").readFilesWithRetries(Sleeper.DEFAULT, BackOff.STOP_BACKOFF), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"hello,42", "goodbye,13"}));
    }

    @Test
    public void testWriteJson() throws Exception {
        File destinationFile = new File(this.tempFolder.getRoot(), "json-outputs");
        String query = "INSERT INTO test(name, age) VALUES ('Jack', 13)";
        String ddl = String.format("CREATE EXTERNAL TABLE test %s TYPE text LOCATION '%s' TBLPROPERTIES '{\"format\":\"json\"}'", SQL_JSON_SCHEMA, destinationFile.getAbsolutePath());
        this.pipeline.apply((PTransform)SqlTransform.query((String)query).withDdlString(ddl));
        this.pipeline.run();
        MatcherAssert.assertThat((Object)new NumberedShardedFile(destinationFile.getAbsolutePath() + "*").readFilesWithRetries(Sleeper.DEFAULT, BackOff.STOP_BACKOFF), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{JSON_TEXT}));
    }
}

