/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.test;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamCalcRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamIOSourceRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.rule.BeamCalcRule;
import org.apache.beam.sdk.extensions.sql.impl.rule.BeamIOPushDownRule;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestTableProvider;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.rules.CoreRules;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.RuleSets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.core.IsInstanceOf;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestTableProviderWithProjectPushDown {
    private static final Schema BASIC_SCHEMA = Schema.builder().addInt32Field("unused1").addInt32Field("id").addStringField("name").addInt32Field("unused2").build();
    private static final List<RelOptRule> rulesWithPushDown = ImmutableList.of((Object)BeamCalcRule.INSTANCE, (Object)CoreRules.FILTER_CALC_MERGE, (Object)CoreRules.PROJECT_CALC_MERGE, (Object)BeamIOPushDownRule.INSTANCE, (Object)CoreRules.FILTER_TO_CALC, (Object)CoreRules.PROJECT_TO_CALC, (Object)CoreRules.CALC_MERGE);
    private BeamSqlEnv sqlEnv;
    @Rule
    public TestPipeline pipeline = TestPipeline.create();

    @Before
    public void buildUp() {
        TestTableProvider tableProvider = new TestTableProvider();
        Table table = TestTableProviderWithProjectPushDown.getTable("TEST", TestTableProvider.PushDownOptions.PROJECT);
        tableProvider.createTable(table);
        tableProvider.addRows(table.getName(), new Row[]{TestTableProviderWithProjectPushDown.row(BASIC_SCHEMA, 100, 1, "one", 100), TestTableProviderWithProjectPushDown.row(BASIC_SCHEMA, 200, 2, "two", 200)});
        this.sqlEnv = BeamSqlEnv.builder((TableProvider)tableProvider).setPipelineOptions(PipelineOptionsFactory.create()).setRuleSets((Collection)ImmutableList.of((Object)RuleSets.ofList(rulesWithPushDown))).build();
    }

    @Test
    public void testIOSourceRel_withNoPredicate() {
        String selectTableStatement = "SELECT id, name FROM TEST";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        Assert.assertEquals((Object)result.getSchema(), (Object)Schema.builder().addInt32Field("id").addStringField("name").build());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithProjectPushDown.row(result.getSchema(), 1, "one"), TestTableProviderWithProjectPushDown.row(result.getSchema(), 2, "two")});
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        MatcherAssert.assertThat((Object)beamRelNode.getRowType().getFieldNames(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"id", "name"}));
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testIOSourceRel_withNoPredicate_withRename() {
        String selectTableStatement = "SELECT id as new_id, name as new_name FROM TEST";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        Assert.assertEquals((Object)result.getSchema(), (Object)Schema.builder().addInt32Field("new_id").addStringField("new_name").build());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithProjectPushDown.row(result.getSchema(), 1, "one"), TestTableProviderWithProjectPushDown.row(result.getSchema(), 2, "two")});
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        MatcherAssert.assertThat((Object)beamRelNode.getRowType().getFieldNames(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"new_id", "new_name"}));
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testIOSourceRel_withPredicate() {
        String selectTableStatement = "SELECT name FROM TEST where id=2";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        Assert.assertEquals((Object)result.getSchema(), (Object)Schema.builder().addStringField("name").build());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithProjectPushDown.row(result.getSchema(), "two")});
        MatcherAssert.assertThat((Object)beamRelNode.getInput(0), (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        MatcherAssert.assertThat((Object)beamRelNode.getInput(0).getRowType().getFieldNames(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"id", "name"}));
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testIOSourceRel_withPredicate_withRename() {
        String selectTableStatement = "SELECT name as new_name FROM TEST where id=2";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        Assert.assertEquals((Object)result.getSchema(), (Object)Schema.builder().addStringField("new_name").build());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithProjectPushDown.row(result.getSchema(), "two")});
        MatcherAssert.assertThat((Object)beamRelNode.getInput(0), (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        MatcherAssert.assertThat((Object)beamRelNode.getRowType().getFieldNames(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"new_name"}));
        MatcherAssert.assertThat((Object)beamRelNode.getInput(0).getRowType().getFieldNames(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"id", "name"}));
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testIOSourceRel_AllFields() {
        String selectTableStatement = "SELECT * FROM TEST";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        Assert.assertEquals((Object)result.getSchema(), (Object)BASIC_SCHEMA);
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithProjectPushDown.row(result.getSchema(), 100, 1, "one", 100), TestTableProviderWithProjectPushDown.row(result.getSchema(), 200, 2, "two", 200)});
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamCalcRel.class));
        MatcherAssert.assertThat((Object)beamRelNode.getInput(0), (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        MatcherAssert.assertThat((Object)beamRelNode.getInput(0).getRowType().getFieldNames(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"unused1", "id", "name", "unused2"}));
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testIOSourceRel_selectOneFieldsMoreThanOnce() {
        String selectTableStatement = "SELECT id, id, id, id, id FROM TEST";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamCalcRel.class));
        MatcherAssert.assertThat((Object)beamRelNode.getInput(0), (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        List pushedFields = beamRelNode.getInput(0).getRowType().getFieldNames();
        MatcherAssert.assertThat((Object)pushedFields, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"id"}));
        Assert.assertEquals((Object)Schema.builder().addInt32Field("id").addInt32Field("id0").addInt32Field("id1").addInt32Field("id2").addInt32Field("id3").build(), (Object)result.getSchema());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithProjectPushDown.row(result.getSchema(), 1, 1, 1, 1, 1), TestTableProviderWithProjectPushDown.row(result.getSchema(), 2, 2, 2, 2, 2)});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testIOSourceRel_selectOneFieldsMoreThanOnce_withSupportedPredicate() {
        String selectTableStatement = "SELECT id, id, id, id, id FROM TEST where id=1";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamCalcRel.class));
        Assert.assertNotNull((Object)((BeamCalcRel)beamRelNode).getProgram().getCondition());
        MatcherAssert.assertThat((Object)beamRelNode.getInput(0), (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        List pushedFields = beamRelNode.getInput(0).getRowType().getFieldNames();
        MatcherAssert.assertThat((Object)pushedFields, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"id"}));
        Assert.assertEquals((Object)Schema.builder().addInt32Field("id").addInt32Field("id0").addInt32Field("id1").addInt32Field("id2").addInt32Field("id3").build(), (Object)result.getSchema());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithProjectPushDown.row(result.getSchema(), 1, 1, 1, 1, 1)});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    private static Row row(Schema schema, Object ... objects) {
        return Row.withSchema((Schema)schema).addValues(objects).build();
    }

    private static Table getTable(String name, TestTableProvider.PushDownOptions options) {
        return Table.builder().name(name).comment(name + " table").schema(BASIC_SCHEMA).properties(JSON.parseObject((String)("{ push_down: \"" + options.toString() + "\" }"))).type("test").build();
    }
}

