/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.test;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamCalcRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamIOSourceRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.rule.BeamCalcRule;
import org.apache.beam.sdk.extensions.sql.impl.rule.BeamIOPushDownRule;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestTableProvider;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.Calc;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.rules.CoreRules;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.RuleSets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.core.IsInstanceOf;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestTableProviderWithFilterPushDown {
    private static final Schema BASIC_SCHEMA = Schema.builder().addInt32Field("unused1").addInt32Field("id").addStringField("name").addInt16Field("unused2").addBooleanField("b").build();
    private static final List<RelOptRule> rulesWithPushDown = ImmutableList.of((Object)BeamCalcRule.INSTANCE, (Object)CoreRules.FILTER_CALC_MERGE, (Object)CoreRules.PROJECT_CALC_MERGE, (Object)BeamIOPushDownRule.INSTANCE, (Object)CoreRules.FILTER_TO_CALC, (Object)CoreRules.PROJECT_TO_CALC, (Object)CoreRules.CALC_MERGE);
    private BeamSqlEnv sqlEnv;
    @Rule
    public TestPipeline pipeline = TestPipeline.create();

    @Before
    public void buildUp() {
        TestTableProvider tableProvider = new TestTableProvider();
        Table table = TestTableProviderWithFilterPushDown.getTable("TEST", TestTableProvider.PushDownOptions.FILTER);
        tableProvider.createTable(table);
        tableProvider.addRows(table.getName(), new Row[]{TestTableProviderWithFilterPushDown.row(BASIC_SCHEMA, 100, 1, "one", (short)100, true), TestTableProviderWithFilterPushDown.row(BASIC_SCHEMA, 200, 2, "two", (short)200, false)});
        this.sqlEnv = BeamSqlEnv.builder((TableProvider)tableProvider).setPipelineOptions(PipelineOptionsFactory.create()).setRuleSets((Collection)ImmutableList.of((Object)RuleSets.ofList(rulesWithPushDown))).build();
    }

    @Test
    public void testIOSourceRel_withFilter_shouldProjectAllFields() {
        String selectTableStatement = "SELECT name FROM TEST where name='two'";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamCalcRel.class));
        Assert.assertNull((Object)((Calc)beamRelNode).getProgram().getCondition());
        MatcherAssert.assertThat((Object)beamRelNode.getInput(0), (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        List projects = beamRelNode.getInput(0).getRowType().getFieldNames();
        MatcherAssert.assertThat((Object)projects, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"unused1", "id", "name", "unused2", "b"}));
        Assert.assertEquals((Object)Schema.builder().addStringField("name").build(), (Object)result.getSchema());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithFilterPushDown.row(result.getSchema(), "two")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testIOSourceRel_selectAll_withSupportedFilter_shouldDropCalc() {
        String selectTableStatement = "SELECT * FROM TEST where name='two'";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        List projects = beamRelNode.getRowType().getFieldNames();
        MatcherAssert.assertThat((Object)projects, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"unused1", "id", "name", "unused2", "b"}));
        Assert.assertEquals((Object)BASIC_SCHEMA, (Object)result.getSchema());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithFilterPushDown.row(result.getSchema(), 200, 2, "two", (short)200, false)});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testIOSourceRel_withSupportedFilter_selectInRandomOrder() {
        String selectTableStatement = "SELECT unused2, id, name FROM TEST where b";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamCalcRel.class));
        Assert.assertNull((Object)((Calc)beamRelNode).getProgram().getCondition());
        MatcherAssert.assertThat((Object)beamRelNode.getInput(0), (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        List projects = beamRelNode.getInput(0).getRowType().getFieldNames();
        MatcherAssert.assertThat((Object)projects, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"unused1", "id", "name", "unused2", "b"}));
        Assert.assertEquals((Object)Schema.builder().addInt16Field("unused2").addInt32Field("id").addStringField("name").build(), (Object)result.getSchema());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithFilterPushDown.row(result.getSchema(), (short)100, 1, "one")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testIOSourceRel_withUnsupportedFilter_calcPreservesCondition() {
        String selectTableStatement = "SELECT name FROM TEST where id+1=2";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamCalcRel.class));
        Assert.assertNotNull((Object)((Calc)beamRelNode).getProgram().getCondition());
        MatcherAssert.assertThat((Object)beamRelNode.getInput(0), (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        List projects = beamRelNode.getInput(0).getRowType().getFieldNames();
        MatcherAssert.assertThat((Object)projects, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"unused1", "id", "name", "unused2", "b"}));
        Assert.assertEquals((Object)Schema.builder().addStringField("name").build(), (Object)result.getSchema());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithFilterPushDown.row(result.getSchema(), "one")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testIOSourceRel_selectAllFieldsInRandomOrder_shouldPushDownSupportedFilter() {
        String selectTableStatement = "SELECT unused2, name, id, b, unused1 FROM TEST where name='two'";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamCalcRel.class));
        Assert.assertNull((Object)((BeamCalcRel)beamRelNode).getProgram().getCondition());
        MatcherAssert.assertThat((Object)beamRelNode.getInput(0), (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        List projects = beamRelNode.getInput(0).getRowType().getFieldNames();
        MatcherAssert.assertThat((Object)projects, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"unused1", "id", "name", "unused2", "b"}));
        Assert.assertEquals((Object)Schema.builder().addInt16Field("unused2").addStringField("name").addInt32Field("id").addBooleanField("b").addInt32Field("unused1").build(), (Object)result.getSchema());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithFilterPushDown.row(result.getSchema(), (short)200, "two", 2, false, 200)});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testIOSourceRel_selectOneFieldsMoreThanOnce() {
        String selectTableStatement = "SELECT b, b, b, b, b FROM TEST";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamCalcRel.class));
        MatcherAssert.assertThat((Object)beamRelNode.getInput(0), (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        List pushedFields = beamRelNode.getInput(0).getRowType().getFieldNames();
        MatcherAssert.assertThat((Object)pushedFields, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"unused1", "id", "name", "unused2", "b"}));
        Assert.assertEquals((Object)Schema.builder().addBooleanField("b").addBooleanField("b0").addBooleanField("b1").addBooleanField("b2").addBooleanField("b3").build(), (Object)result.getSchema());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithFilterPushDown.row(result.getSchema(), true, true, true, true, true), TestTableProviderWithFilterPushDown.row(result.getSchema(), false, false, false, false, false)});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testIOSourceRel_selectOneFieldsMoreThanOnce_withSupportedPredicate() {
        String selectTableStatement = "SELECT b, b, b, b, b FROM TEST where b";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamCalcRel.class));
        Assert.assertNull((Object)((BeamCalcRel)beamRelNode).getProgram().getCondition());
        MatcherAssert.assertThat((Object)beamRelNode.getInput(0), (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        List pushedFields = beamRelNode.getInput(0).getRowType().getFieldNames();
        MatcherAssert.assertThat((Object)pushedFields, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"unused1", "id", "name", "unused2", "b"}));
        Assert.assertEquals((Object)Schema.builder().addBooleanField("b").addBooleanField("b0").addBooleanField("b1").addBooleanField("b2").addBooleanField("b3").build(), (Object)result.getSchema());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithFilterPushDown.row(result.getSchema(), true, true, true, true, true)});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    private static Table getTable(String name, TestTableProvider.PushDownOptions options) {
        return Table.builder().name(name).comment(name + " table").schema(BASIC_SCHEMA).properties(JSON.parseObject((String)("{ push_down: \"" + options.toString() + "\" }"))).type("test").build();
    }

    private static Row row(Schema schema, Object ... objects) {
        return Row.withSchema((Schema)schema).addValues(objects).build();
    }
}

