/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.test;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamCalcRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamIOSourceRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.rule.BeamCalcRule;
import org.apache.beam.sdk.extensions.sql.impl.rule.BeamIOPushDownRule;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestTableProvider;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.rules.CoreRules;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.RuleSets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.core.IsInstanceOf;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestTableProviderWithFilterAndProjectPushDown {
    private static final Schema BASIC_SCHEMA = Schema.builder().addInt32Field("unused1").addInt32Field("id").addStringField("name").addInt16Field("unused2").addBooleanField("b").build();
    private static final List<RelOptRule> rulesWithPushDown = ImmutableList.of((Object)BeamCalcRule.INSTANCE, (Object)CoreRules.FILTER_CALC_MERGE, (Object)CoreRules.PROJECT_CALC_MERGE, (Object)BeamIOPushDownRule.INSTANCE, (Object)CoreRules.FILTER_TO_CALC, (Object)CoreRules.PROJECT_TO_CALC, (Object)CoreRules.CALC_MERGE);
    private BeamSqlEnv sqlEnv;
    @Rule
    public TestPipeline pipeline = TestPipeline.create();

    @Before
    public void buildUp() {
        TestTableProvider tableProvider = new TestTableProvider();
        Table table = TestTableProviderWithFilterAndProjectPushDown.getTable("TEST", TestTableProvider.PushDownOptions.BOTH);
        tableProvider.createTable(table);
        tableProvider.addRows(table.getName(), new Row[]{TestTableProviderWithFilterAndProjectPushDown.row(BASIC_SCHEMA, 100, 1, "one", (short)100, true), TestTableProviderWithFilterAndProjectPushDown.row(BASIC_SCHEMA, 200, 2, "two", (short)200, false)});
        this.sqlEnv = BeamSqlEnv.builder((TableProvider)tableProvider).setPipelineOptions(PipelineOptionsFactory.create()).setRuleSets((Collection)ImmutableList.of((Object)RuleSets.ofList(rulesWithPushDown))).build();
    }

    @Test
    public void testIOSourceRel_predicateSimple() {
        String selectTableStatement = "SELECT name FROM TEST where id=2";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        Assert.assertEquals((Object)Schema.builder().addStringField("name").build(), (Object)result.getSchema());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithFilterAndProjectPushDown.row(result.getSchema(), "two")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testIOSourceRel_predicateSimple_Boolean() {
        String selectTableStatement = "SELECT name FROM TEST where b";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        Assert.assertEquals((Object)Schema.builder().addStringField("name").build(), (Object)result.getSchema());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithFilterAndProjectPushDown.row(result.getSchema(), "one")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testIOSourceRel_predicateWithAnd() {
        String selectTableStatement = "SELECT name FROM TEST where id>=2 and unused1<=200";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        Assert.assertEquals((Object)Schema.builder().addStringField("name").build(), (Object)result.getSchema());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithFilterAndProjectPushDown.row(result.getSchema(), "two")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testIOSourceRel_withComplexProjects_withSupportedFilter() {
        String selectTableStatement = "SELECT name as new_name, unused1+10-id as new_id FROM TEST where 1<id";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamCalcRel.class));
        MatcherAssert.assertThat((Object)beamRelNode.getInput(0), (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        List a = beamRelNode.getInput(0).getRowType().getFieldNames();
        MatcherAssert.assertThat((Object)a, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"name", "unused1", "id"}));
        Assert.assertEquals((Object)Schema.builder().addStringField("new_name").addInt32Field("new_id").build(), (Object)result.getSchema());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithFilterAndProjectPushDown.row(result.getSchema(), "two", 208)});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testIOSourceRel_selectFieldsInRandomOrder_withRename_withSupportedFilter() {
        String selectTableStatement = "SELECT name as new_name, id as new_id, unused1 as new_unused1 FROM TEST where 1<id";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        List a = beamRelNode.getRowType().getFieldNames();
        MatcherAssert.assertThat((Object)a, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"new_name", "new_id", "new_unused1"}));
        Assert.assertEquals((Object)Schema.builder().addStringField("new_name").addInt32Field("new_id").addInt32Field("new_unused1").build(), (Object)result.getSchema());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithFilterAndProjectPushDown.row(result.getSchema(), "two", 2, 200)});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testIOSourceRel_selectFieldsInRandomOrder_withRename_withUnsupportedFilter() {
        String selectTableStatement = "SELECT name as new_name, id as new_id, unused1 as new_unused1 FROM TEST where id+unused1=202";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamCalcRel.class));
        MatcherAssert.assertThat((Object)beamRelNode.getInput(0), (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        List a = beamRelNode.getInput(0).getRowType().getFieldNames();
        MatcherAssert.assertThat((Object)a, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"name", "id", "unused1"}));
        Assert.assertEquals((Object)Schema.builder().addStringField("new_name").addInt32Field("new_id").addInt32Field("new_unused1").build(), (Object)result.getSchema());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithFilterAndProjectPushDown.row(result.getSchema(), "two", 2, 200)});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testIOSourceRel_selectFieldsInRandomOrder_withRename_withSupportedAndUnsupportedFilters() {
        String selectTableStatement = "SELECT name as new_name, id as new_id, unused1 as new_unused1 FROM TEST where 1<id and id+unused1=202";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamCalcRel.class));
        MatcherAssert.assertThat((Object)beamRelNode.getInput(0), (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        List a = beamRelNode.getInput(0).getRowType().getFieldNames();
        MatcherAssert.assertThat((Object)a, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"name", "id", "unused1"}));
        Assert.assertEquals((Object)"BeamPushDownIOSourceRel.BEAM_LOGICAL(table=[beam, TEST],usedFields=[name, id, unused1],TestTableFilter=[supported{<(1, $1)}, unsupported{=(+($1, $0), 202)}])", (Object)beamRelNode.getInput(0).getDigest());
        Assert.assertEquals((Object)Schema.builder().addStringField("new_name").addInt32Field("new_id").addInt32Field("new_unused1").build(), (Object)result.getSchema());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithFilterAndProjectPushDown.row(result.getSchema(), "two", 2, 200)});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testIOSourceRel_selectAllField() {
        String selectTableStatement = "SELECT * FROM TEST where id<>2";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        Assert.assertEquals((Object)"BeamPushDownIOSourceRel.BEAM_LOGICAL(table=[beam, TEST],usedFields=[unused1, id, name, unused2, b],TestTableFilter=[supported{<>($1, 2)}, unsupported{}])", (Object)beamRelNode.getDigest());
        Assert.assertEquals((Object)BASIC_SCHEMA, (Object)result.getSchema());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithFilterAndProjectPushDown.row(result.getSchema(), 100, 1, "one", (short)100, true)});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    private static Row row(Schema schema, Object ... objects) {
        return Row.withSchema((Schema)schema).addValues(objects).build();
    }

    @Test
    public void testIOSourceRel_withUnsupportedPredicate() {
        String selectTableStatement = "SELECT name FROM TEST where id+unused1=101";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamCalcRel.class));
        MatcherAssert.assertThat((Object)beamRelNode.getInput(0), (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        Assert.assertEquals((Object)"BeamPushDownIOSourceRel.BEAM_LOGICAL(table=[beam, TEST],usedFields=[name, id, unused1],TestTableFilter=[supported{}, unsupported{=(+($1, $0), 101)}])", (Object)beamRelNode.getInput(0).getDigest());
        List a = beamRelNode.getInput(0).getRowType().getFieldNames();
        MatcherAssert.assertThat((Object)a, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"name", "id", "unused1"}));
        Assert.assertEquals((Object)Schema.builder().addStringField("name").build(), (Object)result.getSchema());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithFilterAndProjectPushDown.row(result.getSchema(), "one")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testIOSourceRel_selectAll_withUnsupportedPredicate() {
        String selectTableStatement = "SELECT * FROM TEST where id+unused1=101";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamCalcRel.class));
        MatcherAssert.assertThat((Object)beamRelNode.getInput(0), (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        Assert.assertEquals((Object)"BeamIOSourceRel.BEAM_LOGICAL(table=[beam, TEST])", (Object)beamRelNode.getInput(0).getDigest());
        List a = beamRelNode.getInput(0).getRowType().getFieldNames();
        MatcherAssert.assertThat((Object)a, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"name", "id", "unused1", "unused2", "b"}));
        Assert.assertEquals((Object)BASIC_SCHEMA, (Object)result.getSchema());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithFilterAndProjectPushDown.row(result.getSchema(), 100, 1, "one", (short)100, true)});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testIOSourceRel_withSupportedAndUnsupportedPredicate() {
        String selectTableStatement = "SELECT name FROM TEST where id+unused1=101 and id=1";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamCalcRel.class));
        MatcherAssert.assertThat((Object)beamRelNode.getInput(0), (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        Assert.assertEquals((Object)"BeamPushDownIOSourceRel.BEAM_LOGICAL(table=[beam, TEST],usedFields=[name, id, unused1],TestTableFilter=[supported{=($1, 1)}, unsupported{=(+($1, $0), 101)}])", (Object)beamRelNode.getInput(0).getDigest());
        List a = beamRelNode.getInput(0).getRowType().getFieldNames();
        MatcherAssert.assertThat((Object)a, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"name", "id", "unused1"}));
        Assert.assertEquals((Object)Schema.builder().addStringField("name").build(), (Object)result.getSchema());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithFilterAndProjectPushDown.row(result.getSchema(), "one")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testIOSourceRel_selectAll_withSupportedAndUnsupportedPredicate() {
        String selectTableStatement = "SELECT * FROM TEST where id+unused1=101 and id=1";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamCalcRel.class));
        MatcherAssert.assertThat((Object)beamRelNode.getInput(0), (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        Assert.assertEquals((Object)"BeamPushDownIOSourceRel.BEAM_LOGICAL(table=[beam, TEST],usedFields=[unused1, id, name, unused2, b],TestTableFilter=[supported{=($1, 1)}, unsupported{=(+($1, $0), 101)}])", (Object)beamRelNode.getInput(0).getDigest());
        List a = beamRelNode.getInput(0).getRowType().getFieldNames();
        MatcherAssert.assertThat((Object)a, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"unused1", "name", "id", "unused2", "b"}));
        Assert.assertEquals((Object)BASIC_SCHEMA, (Object)result.getSchema());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithFilterAndProjectPushDown.row(result.getSchema(), 100, 1, "one", (short)100, true)});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testIOSourceRel_selectOneFieldsMoreThanOnce() {
        String selectTableStatement = "SELECT b, b, b, b, b FROM TEST";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamCalcRel.class));
        MatcherAssert.assertThat((Object)beamRelNode.getInput(0), (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        List pushedFields = beamRelNode.getInput(0).getRowType().getFieldNames();
        MatcherAssert.assertThat((Object)pushedFields, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"b"}));
        Assert.assertEquals((Object)Schema.builder().addBooleanField("b").addBooleanField("b0").addBooleanField("b1").addBooleanField("b2").addBooleanField("b3").build(), (Object)result.getSchema());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithFilterAndProjectPushDown.row(result.getSchema(), true, true, true, true, true), TestTableProviderWithFilterAndProjectPushDown.row(result.getSchema(), false, false, false, false, false)});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testIOSourceRel_selectOneFieldsMoreThanOnce_withSupportedPredicate() {
        String selectTableStatement = "SELECT b, b, b, b, b FROM TEST where b";
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(selectTableStatement);
        PCollection result = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)IsInstanceOf.instanceOf(BeamCalcRel.class));
        Assert.assertNull((Object)((BeamCalcRel)beamRelNode).getProgram().getCondition());
        MatcherAssert.assertThat((Object)beamRelNode.getInput(0), (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        List pushedFields = beamRelNode.getInput(0).getRowType().getFieldNames();
        MatcherAssert.assertThat((Object)pushedFields, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"b"}));
        Assert.assertEquals((Object)Schema.builder().addBooleanField("b").addBooleanField("b0").addBooleanField("b1").addBooleanField("b2").addBooleanField("b3").build(), (Object)result.getSchema());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderWithFilterAndProjectPushDown.row(result.getSchema(), true, true, true, true, true)});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    private static Table getTable(String name, TestTableProvider.PushDownOptions options) {
        return Table.builder().name(name).comment(name + " table").schema(BASIC_SCHEMA).properties(JSON.parseObject((String)("{ push_down: \"" + options.toString() + "\" }"))).type("test").build();
    }
}

