/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.test;

import com.alibaba.fastjson.JSON;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestTableProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableList;
import org.joda.time.Duration;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestTableProviderTest {
    private static final Schema BASIC_SCHEMA = Schema.builder().addInt32Field("id").addStringField("name").build();
    private BeamSqlTable beamSqlTable;
    @Rule
    public TestPipeline pipeline = TestPipeline.create();

    @Before
    public void buildUp() {
        TestTableProvider tableProvider = new TestTableProvider();
        Table table = TestTableProviderTest.getTable("tableName");
        tableProvider.createTable(table);
        tableProvider.addRows(table.getName(), new Row[]{TestTableProviderTest.row(BASIC_SCHEMA, 1, "one"), TestTableProviderTest.row(BASIC_SCHEMA, 2, "two")});
        this.beamSqlTable = tableProvider.buildBeamSqlTable(table);
    }

    @Test
    public void testInMemoryTableProvider_returnsSelectedColumns() {
        PCollection result = this.beamSqlTable.buildIOReader(this.pipeline.begin(), this.beamSqlTable.constructFilter((List)ImmutableList.of()), (List)ImmutableList.of((Object)"name"));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderTest.row(result.getSchema(), "one"), TestTableProviderTest.row(result.getSchema(), "two")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testInMemoryTableProvider_withEmptySelectedColumns_returnsAllColumns() {
        PCollection result = this.beamSqlTable.buildIOReader(this.pipeline.begin(), this.beamSqlTable.constructFilter((List)ImmutableList.of()), (List)ImmutableList.of());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderTest.row(result.getSchema(), 1, "one"), TestTableProviderTest.row(result.getSchema(), 2, "two")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testInMemoryTableProvider_withAllSelectedColumns_returnsAllColumns() {
        PCollection result = this.beamSqlTable.buildIOReader(this.pipeline.begin(), this.beamSqlTable.constructFilter((List)ImmutableList.of()), (List)ImmutableList.of((Object)"name", (Object)"id"));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderTest.row(result.getSchema(), "one", 1), TestTableProviderTest.row(result.getSchema(), "two", 2)});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testInMemoryTableProvider_withDuplicateSelectedColumns_returnsSelectedColumnsOnce() {
        PCollection result = this.beamSqlTable.buildIOReader(this.pipeline.begin(), this.beamSqlTable.constructFilter((List)ImmutableList.of()), (List)ImmutableList.of((Object)"name", (Object)"name"));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{TestTableProviderTest.row(result.getSchema(), "one"), TestTableProviderTest.row(result.getSchema(), "two")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    private static Row row(Schema schema, Object ... objects) {
        return Row.withSchema((Schema)schema).addValues(objects).build();
    }

    private static Table getTable(String name) {
        return Table.builder().name(name).comment(name + " table").schema(BASIC_SCHEMA).properties(JSON.parseObject((String)("{ push_down: \"" + TestTableProvider.PushDownOptions.BOTH.toString() + "\" }"))).type("test").build();
    }
}

