/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.pubsublite;

import com.alibaba.fastjson.JSONObject;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.testing.UnitTestExamples;
import java.util.Map;
import java.util.function.Function;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.pubsublite.PubsubLiteSubscriptionTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.pubsublite.PubsubLiteTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.pubsublite.PubsubLiteTopicTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.pubsublite.RowHandler;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PubsubLiteTableProviderTest {
    private static final PubsubLiteTableProvider PROVIDER = new PubsubLiteTableProvider();
    private static final Schema FULL_WRITE_SCHEMA = Schema.builder().addByteArrayField("message_key").addDateTimeField("event_timestamp").addArrayField("attributes", Schema.FieldType.row((Schema)RowHandler.ATTRIBUTES_ENTRY_SCHEMA)).addByteArrayField("payload").build();
    private static final Schema FULL_READ_SCHEMA = Schema.builder().addByteArrayField("message_key").addDateTimeField("event_timestamp").addArrayField("attributes", Schema.FieldType.row((Schema)RowHandler.ATTRIBUTES_ENTRY_SCHEMA)).addByteArrayField("payload").addDateTimeField("publish_timestamp").build();

    private static BeamSqlTable makeTable(Schema schema, String location, Map<String, Object> properties) {
        Table table = Table.builder().type(PROVIDER.getTableType()).name("testTable").schema(schema).location(location).properties(new JSONObject().fluentPutAll(properties)).build();
        return PROVIDER.buildBeamSqlTable(table);
    }

    @Test
    public void invalidSchemas() {
        Function<Schema, BeamSqlTable> tableMaker = schema -> PubsubLiteTableProviderTest.makeTable(schema, ((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)).toString(), (Map<String, Object>)ImmutableMap.of());
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            BeamSqlTable cfr_ignored_0 = (BeamSqlTable)tableMaker.apply(Schema.builder().addDateTimeField("event_timestamp").build());
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            BeamSqlTable cfr_ignored_0 = (BeamSqlTable)tableMaker.apply(Schema.builder().addDateTimeField("payload").build());
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            BeamSqlTable cfr_ignored_0 = (BeamSqlTable)tableMaker.apply(Schema.builder().addByteArrayField("payload").addByteArrayField("my-random-field").build());
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            BeamSqlTable cfr_ignored_0 = (BeamSqlTable)tableMaker.apply(Schema.builder().addByteArrayField("payload").addByteArrayField("attributes").build());
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            BeamSqlTable cfr_ignored_0 = (BeamSqlTable)tableMaker.apply(Schema.builder().addByteArrayField("payload").addRowField("attributes", Schema.builder().addStringField("key").addArrayField("badValues", Schema.FieldType.BYTES).build()).build());
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            BeamSqlTable cfr_ignored_0 = (BeamSqlTable)tableMaker.apply(Schema.builder().addByteArrayField("payload").addByteArrayField("event_timestamp").build());
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            BeamSqlTable cfr_ignored_0 = (BeamSqlTable)tableMaker.apply(Schema.builder().addByteArrayField("payload").addByteArrayField("publish_timestamp").build());
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            BeamSqlTable cfr_ignored_0 = (BeamSqlTable)tableMaker.apply(Schema.builder().addByteArrayField("payload").addStringField("message_key").build());
        });
    }

    @Test
    public void bytesWithFormatInvalid() {
        Assert.assertThrows(IllegalArgumentException.class, () -> PubsubLiteTableProviderTest.makeTable(Schema.builder().addByteArrayField("payload").build(), ((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)).toString(), (Map<String, Object>)ImmutableMap.of((Object)"format", (Object)"json")));
    }

    @Test
    public void invalidLocations() {
        Function<String, BeamSqlTable> tableMaker = location -> PubsubLiteTableProviderTest.makeTable(FULL_WRITE_SCHEMA, location, (Map<String, Object>)ImmutableMap.of());
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            BeamSqlTable cfr_ignored_0 = (BeamSqlTable)tableMaker.apply("my-location");
        });
        Assert.assertThrows(ApiException.class, () -> {
            BeamSqlTable cfr_ignored_0 = (BeamSqlTable)tableMaker.apply("projects/abc/topics/def");
        });
        Assert.assertThrows(ApiException.class, () -> {
            BeamSqlTable cfr_ignored_0 = (BeamSqlTable)tableMaker.apply("projects/abc/subscriptions/def");
        });
    }

    @Test
    public void validTopicTables() {
        BeamSqlTable basic = PubsubLiteTableProviderTest.makeTable(FULL_WRITE_SCHEMA, ((TopicPath)UnitTestExamples.example(TopicPath.class)).toString(), (Map<String, Object>)ImmutableMap.of());
        Assert.assertTrue((boolean)(basic instanceof PubsubLiteTopicTable));
        BeamSqlTable row = PubsubLiteTableProviderTest.makeTable(Schema.builder().addRowField("payload", Schema.builder().addStringField("abc").build()).build(), ((TopicPath)UnitTestExamples.example(TopicPath.class)).toString(), (Map<String, Object>)ImmutableMap.of((Object)"format", (Object)"json"));
        Assert.assertTrue((boolean)(row instanceof PubsubLiteTopicTable));
        BeamSqlTable dlq = PubsubLiteTableProviderTest.makeTable(Schema.builder().addRowField("payload", Schema.builder().addStringField("abc").build()).build(), ((TopicPath)UnitTestExamples.example(TopicPath.class)).toString(), (Map<String, Object>)ImmutableMap.of((Object)"deadLetterQueue", (Object)"pubsub:projects/abc/topics/def"));
        Assert.assertTrue((boolean)(dlq instanceof PubsubLiteTopicTable));
    }

    @Test
    public void topicTableCannotRead() {
        BeamSqlTable basic = PubsubLiteTableProviderTest.makeTable(FULL_WRITE_SCHEMA, ((TopicPath)UnitTestExamples.example(TopicPath.class)).toString(), (Map<String, Object>)ImmutableMap.of());
        Assert.assertThrows(UnsupportedOperationException.class, () -> basic.buildIOReader(null));
    }

    @Test
    public void validSubscriptionTables() {
        BeamSqlTable basic = PubsubLiteTableProviderTest.makeTable(FULL_READ_SCHEMA, ((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)).toString(), (Map<String, Object>)ImmutableMap.of());
        Assert.assertTrue((boolean)(basic instanceof PubsubLiteSubscriptionTable));
        BeamSqlTable row = PubsubLiteTableProviderTest.makeTable(Schema.builder().addRowField("payload", Schema.builder().addStringField("abc").build()).build(), ((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)).toString(), (Map<String, Object>)ImmutableMap.of((Object)"format", (Object)"json"));
        Assert.assertTrue((boolean)(row instanceof PubsubLiteSubscriptionTable));
        BeamSqlTable dlq = PubsubLiteTableProviderTest.makeTable(Schema.builder().addRowField("payload", Schema.builder().addStringField("abc").build()).build(), ((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)).toString(), (Map<String, Object>)ImmutableMap.of((Object)"format", (Object)"json", (Object)"deadLetterQueue", (Object)"pubsub:projects/abc/topics/def"));
        Assert.assertTrue((boolean)(dlq instanceof PubsubLiteSubscriptionTable));
    }

    @Test
    public void subscriptionTableCannotWrite() {
        BeamSqlTable basic = PubsubLiteTableProviderTest.makeTable(FULL_READ_SCHEMA, ((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)).toString(), (Map<String, Object>)ImmutableMap.of());
        Assert.assertThrows(UnsupportedOperationException.class, () -> basic.buildIOWriter(null));
    }
}

